<?php
add_action( 'init', 'artist_service' );
function artist_service(){
	 $labels = array( 
        'name' => _x( 'Services', 'services', 'artist' ),
        'singular_name' => _x( 'Services', 'services', 'artist' ),
        'add_new' => _x( 'Add New', 'services', 'artist' ),
        'add_new_item' => _x( 'Add New Services', 'services', 'artist' ),
        'edit_item' => _x( 'Edit Services', 'services', 'artist' ),
        'new_item' => _x( 'New Services', 'services', 'artist' ),
        'view_item' => _x( 'View Services', 'services', 'artist' ),
        'search_items' => _x( 'Search Services', 'services', 'artist' ),
        'not_found' => _x( 'No services found', 'services', 'artist' ),
        'not_found_in_trash' => _x( 'No services member found in Trash', 'services', 'artist' ),
        'parent_item_colon' => _x( 'Parent Services:', 'services', 'artist' ),
        'menu_name' => _x( 'Services ', 'services', 'artist' ),
		'all_items' => _x( 'All Services ', 'services', 'artist' ),
		'search_items' => _x( 'No services found', 'services', 'artist' )
    );
	$args = array( 
        'labels' => $labels,
        'hierarchical' => false,
        'supports' => array( 'title', 'editor' ,'thumbnail' ),
        'public' => true,  
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => true,
		'menu_icon' => 'dashicons-clipboard',
    );
	register_post_type( 'services', $args );
}
/*====================portfolio=============*/
add_action( 'init', 'artist_portfolio' );
function artist_portfolio() {
	$labels = array( 
        'name' => _x( 'Portfolio', 'Portfolio', 'artist' ),
        'singular_name' => _x( 'Portfolio', 'Portfolio', 'artist' ),
        'add_new' => _x( 'Add New', 'Portfolio', 'artist' ),
        'add_new_item' => _x( 'Add New Portfolio', 'Portfolio', 'artist' ),
        'edit_item' => _x( 'Edit Portfolio', 'Portfolio', 'artist' ),
        'new_item' => _x( 'New Portfolio', 'Portfolio', 'artist' ),
        'view_item' => _x( 'View Portfolio', 'Portfolio', 'artist' ),
        'search_items' => _x( 'Search Portfolio', 'Portfolio', 'artist' ),
        'not_found' => _x( 'No Portfolio found', 'Portfolio', 'artist' ),
        'not_found_in_trash' => _x( 'No Portfolio member found in Trash', 'Portfolio', 'artist' ),
        'parent_item_colon' => _x( 'Parent Portfolio:', 'Portfolio', 'artist' ),
        'menu_name' => _x( 'Portfolio ', 'Portfolio', 'artist' ),
		'all_items' => _x( 'All Portfolio ', 'Portfolio', 'artist' ),
		'search_items' => _x( 'No Portfolio found', 'Portfolio', 'artist' )
    );
	$args = array( 
        'labels' => $labels,
        'hierarchical' => false,
        'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'revisions','post-formats' ), 
        'public' => true,  
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => true,
		'menu_icon' => 'dashicons-format-gallery',
    );
	register_post_type( 'portfolio', $args );
}
// add taxonomies to categorize different custom post types
add_action( 'init', 'portfoliobuild_taxonomies', 0);
function portfoliobuild_taxonomies() {
register_taxonomy("portfolio_categories", array("portfolio"), array("hierarchical" => true, "label" => "Categories", "singular_label" => "Category", "rewrite" => true));
} 
/*====================testimonial=============*/
add_action( 'init', 'artist_testimonial' );
function artist_testimonial() {
	$labels = array( 
        'name' => _x( 'Testimonial', 'Testimonial', 'artist' ),
        'singular_name' => _x( 'Testimonial', 'Testimonial', 'artist' ),
        'add_new' => _x( 'Add New', 'Testimonial', 'artist' ),
        'add_new_item' => _x( 'Add New Testimonial', 'Testimonial', 'artist' ),
        'edit_item' => _x( 'Edit Testimonial', 'Testimonial', 'artist' ),
        'new_item' => _x( 'New Testimonial', 'Testimonial', 'artist' ),
        'view_item' => _x( 'View Testimonial', 'Testimonial', 'artist' ),
        'search_items' => _x( 'Search Testimonial', 'Testimonial', 'artist' ),
        'not_found' => _x( 'No Testimonial found', 'Testimonial', 'artist' ),
        'not_found_in_trash' => _x( 'No Testimonial member found in Trash', 'Testimonial', 'artist' ),
        'parent_item_colon' => _x( 'Parent Testimonial:', 'Testimonial', 'artist' ),
        'menu_name' => _x( 'Testimonial ', 'Testimonial', 'artist' ),
		'all_items' => _x( 'All Testimonial ', 'Testimonial', 'artist' ),
		'search_items' => _x( 'No Testimonial found', 'Testimonial', 'artist' )
    );
	$args = array( 
        'labels' => $labels,
        'hierarchical' => false,
        'supports' => array( 'title' ), 
        'public' => false,  
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => false,
		'menu_icon' => 'dashicons-editor-quote',
    );
	register_post_type( 'testimonial', $args );
}
/*====================Team======================*/
add_action( 'init', 'artist_team' );
function artist_team(){
	 $labels = array( 
        'name' => _x( 'Team', 'Team', 'artist' ),
        'singular_name' => _x( 'Team', 'Team', 'artist' ),
        'add_new' => _x( 'Add New', 'Team', 'artist' ),
        'add_new_item' => _x( 'Add New Team Member', 'Team', 'artist' ),
        'edit_item' => _x( 'Edit Team', 'Team', 'artist' ),
        'new_item' => _x( 'New Team', 'Team', 'artist' ),
        'view_item' => _x( 'View Team', 'Team', 'artist' ),
        'search_items' => _x( 'Search Team', 'Team', 'artist' ),
        'not_found' => _x( 'No Team found', 'Team', 'artist' ),
        'not_found_in_trash' => _x( 'No Team member found in Trash', 'Team', 'artist' ),
        'parent_item_colon' => _x( 'Parent Team:', 'Team', 'artist' ),
        'menu_name' => _x( 'Team ', 'Team', 'artist' ),
		'all_items' => _x( 'All Team ', 'Team', 'artist' ),
		'search_items' => _x( 'No Team found', 'Team', 'artist' )
    );
	$args = array( 
        'labels' => $labels,
        'hierarchical' => false,
        'supports' => array( 'title' ),
        'public' => false,  
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => false,
		'menu_icon' => 'dashicons-groups',
    );
	register_post_type( 'team', $args );
}
?>