<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $wp_query;

if ( $wp_query->max_num_pages <= 1 ) {
	return;
}
?>
<div class="artist_pager_navigation">
	<?php
		global $wp_query;
		$big = 999999999; // need an unlikely integer
		$pages = paginate_links( array(
            'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
            'format' => '?paged=%#%',
            'current' => max( 1, get_query_var('paged') ),
            'total' => $wp_query->max_num_pages,
            'prev_next' => false,
            'type'  => 'array',
            'prev_next'   => TRUE,
			'prev_text'    => '« Previous Page',
			'next_text'    => 'Next Page »',
        ) );
        if( is_array( $pages ) ) {
            $paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
			$current = max( 1, get_query_var( 'paged' ) );
            echo '<ul>';
            foreach ( $pages as $page ) {
				if($current == strip_tags($page)){
					echo "<li class='active'><a href=''>$current</a></li>";
				}else{
					echo "<li>$page</li>";
				}
            }
           echo '</ul>';
        }
		
		/*echo paginate_links( apply_filters( 'woocommerce_pagination_args', array(
			'base'         => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
			'format'       => '',
			'add_args'     => '',
			'current'      => max( 1, get_query_var( 'paged' ) ),
			'total'        => $wp_query->max_num_pages,
			'prev_text'    => '« Previous Page',
			'next_text'    => 'Next Page »',
			'type'         => 'list',
			'end_size'     => 3,
			'mid_size'     => 3,
			'before_page_number' => 'aa',
			'after_page_number'  => 'bb'
		) ) );*/
	?>
</div>
