<?php 
/*============================================
Load admin scripts
=============================================*/
function artist_adminload_script() {
	wp_enqueue_style('ui', ARTIST_PATH . '/css/admin/jquery-ui-1.8.21.custom.css', 'ui');
	wp_enqueue_style('admin', ARTIST_PATH . '/css/admin/admin.css', 'admin');
	wp_enqueue_style('social', ARTIST_PATH . '/css/social_icons.css', 'social');
	wp_enqueue_style('artistfont',ARTIST_PATH . '/css/fonts/stylesheet.css');
	wp_enqueue_style('thickbox');
	add_editor_style('css/admin/editor-style.css');
	wp_enqueue_script('jquery');  
	wp_enqueue_script('jquery-ui-core');
	wp_enqueue_script('jquery-ui-widget');
	wp_enqueue_script('jquery-ui-tabs');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-dialog');
	wp_enqueue_script('jquery-ui-slider');

	wp_enqueue_script('admin', ARTIST_PATH. '/js/admin/admin.js', 'admin');
	wp_enqueue_script('json2', ARTIST_PATH. '/js/admin/json2.js', 'json2');	
	wp_enqueue_script('ibutton', ARTIST_PATH. '/js/admin/jquery.ibutton.min.js', 'ibutton');
	wp_enqueue_script('webfont', 'http://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js');
	wp_enqueue_script('thickbox');	  
	wp_enqueue_script('media-upload');	
	wp_enqueue_script('editor'); 	
}
function artist_admin_scripts() {
wp_register_script('color-picker', ARTIST_PATH.'/js/admin/colorpicker.js', array('jquery'));
	wp_register_script('upload-meta-box', ARTIST_PATH.'/js/admin/upload-meta-box.js', array('jquery'));
	wp_enqueue_script('color-picker'); 
	wp_enqueue_script('upload-meta-box');
	wp_enqueue_script('adminsectionjs');  
}
function artist_admin_styles()
{
wp_enqueue_style( 'colorp', ARTIST_PATH.'/css/admin/colorpicker.css');
}
add_action('admin_print_scripts','artist_admin_scripts'); 
add_action('admin_print_styles', 'artist_admin_styles');
add_action('admin_enqueue_scripts','artist_adminload_script'); 
/*============================================
Load scripts 
=============================================*/
add_action('wp_enqueue_scripts', 'artist_enqueue_js');
function artist_enqueue_js()
{   
    wp_register_script('jquery_validation',ARTIST_PATH . '/js/validation.js', array('jquery'),null,true);
    wp_register_script('jquery_custum', ARTIST_PATH . '/js/custum.js', array('jquery'),null,true); 	
	wp_register_script('bootstrap', ARTIST_PATH . '/js/bootstrap.js', array('jquery'),null,true);	
	wp_register_script('mixitup', ARTIST_PATH . '/js/jquery.mixitup.js', array('jquery'),null,true);   
	wp_register_script('bxslider', ARTIST_PATH . '/js/bxslider.js', array('jquery'),null,true);   
	wp_register_script('fancyboxjs', ARTIST_PATH . '/js/jquery.fancybox.js', array('jquery'),null,true);   
	wp_register_script('easing', ARTIST_PATH . '/js/jquery.easing.js', array('jquery'),null,true);      
	wp_register_script('smoothscroll', ARTIST_PATH . '/js/smoothscroll.js', array('jquery'),null,true);      
	wp_register_script('wow', ARTIST_PATH . '/js/wow.js', array('jquery'),null,true);      
	wp_register_script('ie', ARTIST_PATH . '/js/ie.js', array('jquery'),null,true);      
	wp_register_script('mapjuery', 'http://maps.googleapis.com/maps/api/js?key=&sensor=false', array('jquery'));      
		/*===================*/ 
		/* Enqueue Stylesheets */
		/*===================*/
		wp_enqueue_script('jquery');
		wp_enqueue_script('jquery_validation');
		wp_enqueue_script('jquery_custum');
		wp_enqueue_script('bootstrap');
		wp_enqueue_script('mixitup');  
		wp_enqueue_script('bxslider');  
		wp_enqueue_script('fancyboxjs');  
		wp_enqueue_script('easing');   
		wp_enqueue_script('smoothscroll');   
		wp_enqueue_script('wow');   
		wp_enqueue_script('ie');   
		wp_enqueue_script('mapjuery');
		if ( is_singular() && get_option( 'thread_comments' ) ) 
			wp_enqueue_script( 'comment-reply' );
}
/*==================================================
include css in frontend 
===============================================*/ 
function artist_frontend_styles()
{
   /* ------------------------------------------------------------------------ */
	/* Register Stylesheets */ 
	/* ------------------------------------------------------------------------ */
	wp_register_style('defaultbasic', get_stylesheet_uri(), array(), '1', 'all'); 
	wp_register_style('basic', ARTIST_PATH . '/css/style.css', array(), '1', 'all'); 
	wp_register_style('basicfonts', ARTIST_PATH . '/css/fonts/stylesheet.css', array(), '1', 'all'); 
	wp_register_style('slider_scroll', ARTIST_PATH . '/css/slider_scroll.css', array(), '1', 'all'); 
	wp_register_style('bootstrap', ARTIST_PATH . '/css/bootstrap.min.css', array(), '1', 'all'); 
	wp_register_style('animate', ARTIST_PATH . '/css/animate.css', array(), '1', 'all'); 
	wp_register_style('layout', ARTIST_PATH . '/css/layout.css', array(), '1', 'all'); 
	wp_register_style('shop', ARTIST_PATH . '/css/shop.css', array(), '1', 'all');   
	wp_register_style('fancyboxcss', ARTIST_PATH . '/css/jquery.fancybox.css', array(), '1', 'all');   
	wp_register_style('responsive', ARTIST_PATH . '/css/responsive.css', array(), '1', 'all');   
	
	/* ------------------------------------------------------------------------ */
	/* Enqueue Stylesheets */
	/* ------------------------------------------------------------------------ */
	wp_enqueue_style('defaultbasic');	
	wp_enqueue_style('basic');	
	wp_enqueue_style('basicfonts'); 
	wp_enqueue_style('slider_scroll'); 
	wp_enqueue_style('bootstrap');  
	wp_enqueue_style('animate'); 
	wp_enqueue_style('layout');    
	wp_enqueue_style('shop');   
	wp_enqueue_style('fancyboxcss');  
	wp_enqueue_style('responsive');  
	if ( class_exists( 'WooCommerce' ) ) {
		wp_register_style('woocommerce', ARTIST_PATH . '/css/artist-woocommerce.css', array(), '1', 'all');   
		wp_enqueue_style('woocommerce');   
	}
}   
add_action('wp_enqueue_scripts','artist_frontend_styles',1);   
?>