<?php
/**
 * The template part for displaying a message that posts cannot be found.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Artist
 */
?>  
<section class="no-results not-found">
	<div class="span12 hs_left hs_heading_part"> 
		<img src="<?php $src = ARTIST_PATH.'/images/seprator.png';
			echo esc_url($src); ?>" alt="seprator"/> 
	</div>
	<div class="span7 hs_inner_heading wow fadeInDown">
        <h1> <?php _e( 'Nothing Found', 'artist' ); ?> </h1>
      </div>
	<div class="span12 hs_left hs_heading_part"> 
		<img src="<?php $src = ARTIST_PATH.'/images/seprator.png';
			echo esc_url($src); ?>" alt="seprator"/> 
	</div>
	
	<div class="span12 text-center artist_margin_top_50">
		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
			<h2><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'artist' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></h2>
		<?php elseif ( is_search() ) : ?>
			<?php get_search_form(); ?>
			<h2><?php _e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'artist' ); ?></h2>
		<?php else : ?>
			<?php get_search_form(); ?>
			<h2><?php _e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'artist' ); ?></h2>
		<?php endif; ?>
	</div><!-- .page-content -->
</section><!-- .no-results -->