
/**
 * Slideshow JS Bundle
 *
 * @file        slideshow.js
 * @copyright   (C) FastLine Media (www.fastlinemedia.com)
 * @license     http://cdn.fastlinemedia.com/fastlinejs/license.txt
 */
YUI.add("fl-event-move",function(B){var A={_isEndEvent:false,on:function(D,C,E){if(this.type.indexOf("end")>-1){this._isEndEvent=true;}C._direction=this.type.replace("gesturemove","").replace("end","");if(window.navigator.msPointerEnabled){C._startHandle=D.on("MSPointerDown",this._onStart,this,D,C,E);C._moveHandle=D.on("MSPointerMove",this._onMove,this,D,C,E);C._endHandle=D.on("MSPointerUp",this._onEnd,this,D,C,E);}else{C._startHandle=D.on("gesturemovestart",this._onStart,null,this,D,C,E);C._moveHandle=D.on("gesturemove",this._onMove,null,this,D,C,E);C._endHandle=D.on("gesturemoveend",this._onEnd,{standAlone:true},this,D,C,E);}},detach:function(D,C,E){C._startHandle.detach();C._startHandle=null;C._moveHandle.detach();C._moveHandle=null;C._endHandle.detach();C._endHandle=null;},_onStart:function(F,D,C,E){C._doMove=null;C._startX=F.pageX;C._startY=F.pageY;},_onMove:function(F,D,C,E){if(this._checkDirection(F,C)){C._doMove=true;}else{C._doMove=false;}if(C._doMove&&!this._isEndEvent){E.fire(F);}},_onEnd:function(F,D,C,E){if(C._doMove&&this._isEndEvent){F.startPageX=C._startX;F.startPageY=C._startY;E.fire(F);}C._doMove=null;},_checkDirection:function(F,C){var E=Math.abs(C._startX-F.pageX),D=Math.abs(C._startY-F.pageY);if(D>E&&C._startY>F.pageY&&C._direction=="vertical"){return true;}else{if(D>E&&C._startY<F.pageY&&C._direction=="vertical"){return true;}else{if(D<E&&C._startX>F.pageX&&C._direction=="horizontal"){return true;}else{if(D<E&&C._startX<F.pageX&&C._direction=="horizontal"){return true;}}}}return false;}};B.Event.define("gesturemovevertical",A);B.Event.define("gesturemoveverticalend",A);B.Event.define("gesturemovehorizontal",A);B.Event.define("gesturemovehorizontalend",A);},"2.0.0",{requires:["event-move"]});YUI.add("fl-slideshow",function(A){A.namespace("FL").SlideshowCaption=A.Base.create("fl-slideshow-caption",A.Widget,[A.WidgetChild],{_textToggled:false,_textToggleLink:null,renderUI:function(){var B=this.get("root"),C=this.get("boundingBox");this._textToggleLink=A.Node.create('<a href="javascript:void(0);"></a>');this._textToggleLink.addClass("fl-slideshow-caption-toggle");this._textToggleLink.set("innerHTML",B.get("captionMoreLinkText"));C.appendChild(this._textToggleLink);},bindUI:function(){this.get("root").on("imageLoadComplete",A.bind(this._setText,this));this._textToggleLink.on("click",A.bind(this._toggleText,this));},_setText:function(){var C=this.get("root"),E=C.imageInfo.caption,D=C.get("captionTextLength"),B=this.get("contentBox");if(!C.imageInfo.caption||C.imageInfo.caption===""){B.set("innerHTML","");this._textToggleLink.setStyle("display","none");return;}else{if(D>-1){if(!this._textToggled&&D<E.length){E=this._shortenText(E);this._textToggleLink.setStyle("display","inline-block");}else{if(this._textToggled&&D<E.length){E=this._stripTags(E);this._textToggleLink.setStyle("display","inline-block");}else{E=this._stripTags(E);this._textToggleLink.setStyle("display","none");}}}else{E=this._stripTags(E);}}B.set("innerHTML",E);},_toggleText:function(){var C=this.get("root"),D=C.imageInfo.caption,B=this.get("contentBox");if(this._textToggled){D=this._shortenText(D);this._textToggleLink.set("innerHTML",C.get("captionMoreLinkText"));this._textToggled=false;}else{D=this._stripTags(D);this._textToggleLink.set("innerHTML",C.get("captionLessLinkText"));this._textToggled=true;}B.set("innerHTML",D);},_stripTags:function(E,C){var B=this.get("root"),D;if(C||B.get("captionStripTags")){D=document.createElement("div");D.innerHTML=E;E=D.textContent||D.innerText;}return E;},_shortenText:function(C){var B=this.get("root");C=this._stripTags(C,true).substring(0,B.get("captionTextLength"));return A.Lang.trim(C.substring(0,C.lastIndexOf(" ")))+" ...";}},{CSS_PREFIX:"fl-slideshow-caption",ATTRS:{}});A.namespace("FL").SlideshowFrame=A.Base.create("fl-slideshow-frame",A.Widget,[A.WidgetParent,A.WidgetChild],{_imageInfo:null,_activeImage:null,_nextImage:null,_loadQueue:null,_transition:null,_transitioning:false,_resizeAfterTransition:false,_gestures:null,initializer:function(){var B=this.get("imageConfig");this._activeImage=new A.FL.SlideshowImage(B);this._nextImage=new A.FL.SlideshowImage(B);},renderUI:function(){this.add(this._activeImage);this.add(this._nextImage);},bindUI:function(){var B=this._activeImage.get("boundingBox"),C=this._nextImage.get("boundingBox"),D=this.get("transition");if(("ontouchstart" in window||window.navigator.msPointerEnabled)&&this.get("touchSupport")){this._gestures=new A.FL.SlideshowGestures({direction:D=="slideVertical"?"vertical":"horizontal",activeItem:B,nextItem:C});this._gestures.on("moveStart",this._gesturesMoveStart,this);this._gestures.on("endComplete",this._gesturesEndComplete,this);}},syncUI:function(){var C=this._activeImage.get("boundingBox"),D=this._nextImage.get("boundingBox"),B=this.get("contentBox");C.setStyle("position","absolute");C.setStyle("top","0px");C.setStyle("left","-9999px");D.setStyle("position","absolute");D.setStyle("top","0px");D.setStyle("left","-9999px");B.setStyle("position","relative");B.setStyle("overflow","hidden");},load:function(C){var B=this._activeImage._imageInfo;if(this._transitioning){this._loadQueue=C;return;}else{if(B&&B.largeURL==C.largeURL){return;}}this._imageInfo=C;this._transitionInit(C);},preload:function(C,D,B){this._imageInfo=C;this._nextImage.preload(C,D,B);},unload:function(){this._imageInfo=null;this._loadQueue=null;this._transitioning=false;this._transition=null;this._activeImage.detachAll();this._activeImage.unload();this._activeImage.get("boundingBox").setStyle("left","-9999px");this._nextImage.detachAll();this._nextImage.unload();this._nextImage.get("boundingBox").setStyle("left","-9999px");},resize:function(C,B){if(!C||!B){return;}var E=this.get("boundingBox"),D=[parseInt(E.getComputedStyle("paddingTop"),10),parseInt(E.getComputedStyle("paddingRight"),10),parseInt(E.getComputedStyle("paddingBottom"),10),parseInt(E.getComputedStyle("paddingLeft"),10)];C=C-D[1]-D[3];B=B-D[0]-D[2];this.set("width",C);this.set("height",B);if(this._transitioning){this._resizeAfterTransition=true;}else{this._activeImage.resize(C,B);this._nextImage.resize(C,B);}},_getTransition:function(){var B=this.get("root"),E=B.albumInfo.images.length-1,C="next",D=B.get("transition");if(B.lastImageIndex===null){C="";}else{if(B.imageIndex==E&&B.lastImageIndex===0){C="prev";}else{if(B.imageIndex===0&&B.lastImageIndex==E){C="next";}else{if(B.lastImageIndex>B.imageIndex){C="prev";}else{if(B.lastImageIndex<B.imageIndex){C="next";}}}}}if(C=="next"){D=D.replace("slideHorizontal","slideLeft");D=D.replace("slideVertical","slideUp");}else{if(C=="prev"){D=D.replace("slideHorizontal","slideRight");D=D.replace("slideVertical","slideDown");}}return D;},_transitionInit:function(B){this._transitioning=true;if(this._gestures){this._gestures.disable();}this.fire("transitionInit");if(B){this._nextImage.once("loadComplete",this._transitionStart,this);this._nextImage.load(B);}else{this._transitionStart();}},_transitionStart:function(){var B=this.get("root");this.fire("transitionStart");this._transition=new A.FL.SlideshowTransition({itemIn:this._nextImage._imageInfo?this._nextImage.get("boundingBox"):null,itemOut:this._activeImage._imageInfo?this._activeImage.get("boundingBox"):null,type:this._getTransition(),duration:B.get("transitionDuration"),easing:B.get("transitionEasing"),kenBurnsDuration:B.get("speed")/1000,kenBurnsZoom:B.get("kenBurnsZoom")});if(this._nextImage._imageInfo){this._nextImage.get("boundingBox").setStyle("left","0px");}this._transition.once("complete",this._transitionComplete,this);this._transition.run();},_transitionComplete:function(){var B=this.get("root");this._swapImageRefs();this.fire("transitionComplete");this._transition=null;this._transitioning=false;
if(this._gestures){if(B&&B.albumInfo.images.length<=1){this._gestures.disable();}else{this._gestures.enable();}}if(this._loadQueue){this.load(this._loadQueue);this._loadQueue=null;}else{if(this._resizeAfterTransition){this._resizeAfterTransition=false;this._activeImage.resize(this.get("width"),this.get("height"));this._nextImage.resize(this.get("width"),this.get("height"));}}},_gesturesMoveStart:function(D){var C=0,B=this.get("root");C=D.direction=="next"?B.imageIndex+1:B.imageIndex-1;C=C<0?B.albumInfo.images.length-1:C;C=C>=B.albumInfo.images.length?0:C;B.pause();B._hideLoadingImage();B._showLoadingImageWithDelay();A.FL.SlideshowImageLoader.removeGroup(this._nextImage.get("loadGroup"));this._nextImage.once("loadComplete",B._hideLoadingImage,B);this._nextImage.load(B.albumInfo.images[C]);},_gesturesEndComplete:function(){var B=this.get("root"),C=this._nextImage._imageInfo.index;this._swapImageRefs();this._imageInfo=B.albumInfo.images[C];B.loadImage(C);},_swapImageRefs:function(){var B=this._activeImage;this._activeImage=this._nextImage;this._nextImage=B;if(this._nextImage._imageInfo){this._nextImage.unload();this._nextImage.get("boundingBox").setStyle("left","-9999px");}if(this._gestures){this._gestures.set("activeItem",this._activeImage.get("boundingBox"));this._gestures.set("nextItem",this._nextImage.get("boundingBox"));}}},{CSS_PREFIX:"fl-slideshow-frame",ATTRS:{imageConfig:{value:null},touchSupport:{value:false}}});A.namespace("FL").SlideshowFullscreen=A.Base.create("fl-slideshow-fullscreen",A.Plugin.Base,[],{active:false,_closeMessage:null,_closeMessageTimer:null,_initialStyles:{position:"static",top:"0px",left:"0px"},initializer:function(){var C=this.get("host"),D=C.get("boundingBox"),B=this;D.addClass("fl-fullscreen-enabled");if(A.FL.SlideshowFullscreen.OS_SUPPORT){document.addEventListener("fullscreenchange",function(){B._osChange();},false);document.addEventListener("mozfullscreenchange",function(){B._osChange();},false);document.addEventListener("webkitfullscreenchange",function(){B._osChange();},false);}else{this._renderCloseMessage();}},toggle:function(){if(this.active){this.exit();}else{this.enter();}},enter:function(){if(A.FL.SlideshowFullscreen.OS_SUPPORT){this._osEnter();}else{this._browserEnter();}},exit:function(){if(A.FL.SlideshowFullscreen.OS_SUPPORT){this._osExit();}else{this._browserExit();}},_osEnter:function(){var B=this.get("host").get("boundingBox")._node;if(B.webkitRequestFullScreen){B.webkitRequestFullScreen();}else{if(B.mozRequestFullScreen){B.mozRequestFullScreen();}else{if(B.requestFullScreen){B.requestFullScreen();}}}},_osExit:function(){if(document.exitFullscreen){document.exitFullscreen();}else{if(document.mozCancelFullScreen){document.mozCancelFullScreen();}else{if(document.webkitCancelFullScreen){document.webkitCancelFullScreen();}}}},_osChange:function(){var B=this.get("host");if(B.frame&&B.frame._transitioning){B.frame._transitionComplete();}if(this.active){this._exit();}else{this._enter();}},_browserEnter:function(){var B=this.get("host").get("boundingBox");this._initialStyles={position:B.getStyle("position"),top:B.getStyle("top"),left:B.getStyle("left"),zIndex:B.getStyle("zIndex")};B.setStyles({position:"fixed",top:"0px",left:"0px",zIndex:10000});A.Node.one("body").on("fl-fullscreen|keydown",A.bind(this._onKey,this));this._showCloseMessage();this._enter();},_browserExit:function(){var B=this.get("host").get("boundingBox");B.setStyles({position:this._initialStyles.position,top:this._initialStyles.top,left:this._initialStyles.left,zIndex:this._initialStyles.zIndex});A.Node.one("body").detach("fl-fullscreen|keydown");this._hideCloseMessage();this._exit();},_enter:function(){var B=this.get("host"),C=B.get("boundingBox");C.addClass("fl-fullscreen-active");this.active=true;B.resize();},_exit:function(){var B=this.get("host"),C=B.get("boundingBox");C.removeClass("fl-fullscreen-active");this.active=false;B.resize();},_onKey:function(B){if(B.keyCode==27){this.exit();return false;}},_renderCloseMessage:function(){this._closeMessage=A.Node.create('<div class="fl-fullscreen-close-message"></div>');this._closeMessage.set("innerHTML",'<span>Press the "esc" button to exit fullscreen mode.</span>');this._closeMessage.setStyle("display","none");this.get("host").get("boundingBox").insert(this._closeMessage);},_showCloseMessage:function(){if(this._closeMessageTimer){this._closeMessageTimer.cancel();this._closeMessageTimer=null;}this._closeMessage.show(true);this._closeMessageTimer=A.later(4000,this,this._hideCloseMessage);},_hideCloseMessage:function(){if(this._closeMessageTimer){this._closeMessageTimer.cancel();this._closeMessageTimer=null;}this._closeMessage.hide(true);}},{NS:"fullscreen",OS_SUPPORT:(function(){var B=document.documentElement;return B.webkitRequestFullScreen||B.mozRequestFullScreen||B.requestFullScreen;})()});A.namespace("FL").SlideshowGestures=A.Base.create("fl-slideshow-gestures",A.Base,[],{_startX:null,_startY:null,_touchMoving:false,_moving:false,_movingDirection:null,_transitioning:false,initializer:function(){this.enable();},enable:function(){var E=this.get("id"),D=this.get("direction"),C=this.get("activeItem"),B=this.get("nextItem");C.on(E+"|gesturemovestart",A.bind(this._onStart,this));B.on(E+"|gesturemovestart",A.bind(this._onStart,this));if(D=="horizontal"){C.on(E+"|gesturemovehorizontal",A.bind(this._onMoveHorizontal,this));C.on(E+"|gesturemovehorizontalend",A.bind(this._onEndHorizontal,this));B.on(E+"|gesturemovehorizontal",A.bind(this._onMoveHorizontal,this));B.on(E+"|gesturemovehorizontalend",A.bind(this._onEndHorizontal,this));}else{C.on(E+"|gesturemovevertical",A.bind(this._onMoveVertical,this));C.on(E+"|gesturemoveverticalend",A.bind(this._onEndVertical,this));B.on(E+"|gesturemovevertical",A.bind(this._onMoveVertical,this));B.on(E+"|gesturemoveverticalend",A.bind(this._onEndVertical,this));}},disable:function(){var D=this.get("id"),C=this.get("activeItem"),B=this.get("nextItem");C.detach(D+"|*");B.detach(D+"|*");},_onStart:function(C){var B=this.get("direction");
if(this._transitioning){this._onEndComplete();}if(B=="horizontal"){this._startX=C.pageX;}else{this._startY=C.pageY;}this.fire("start");},_onMoveHorizontal:function(G){var B=this._startX-G.pageX,F=this.get("activeItem"),D=this.get("nextItem"),C=parseInt(F.getComputedStyle("width"),10),H=B<0?Math.abs(B):-B,E=B<0?"prev":"next";G.preventDefault();if(!this._moving||this._movingDirection!=E){F.setStyle("left",0);D.setStyles({"opacity":1,"left":B<0?-C:C});this._moving=true;this._movingDirection=E;this.fire("moveStart",{direction:E});}F.setStyle("-webkit-transform","translate("+H+"px, 0px) translateZ(0px)");F.setStyle("-ms-transform","translate("+H+"px, 0px) translateZ(0px)");D.setStyle("-webkit-transform","translate("+H+"px, 0px) translateZ(0px)");D.setStyle("-ms-transform","translate("+H+"px, 0px) translateZ(0px)");this.fire("move");},_onMoveVertical:function(F){var H=this._startY-F.pageY,E=this.get("activeItem"),C=this.get("nextItem"),B=parseInt(E.getComputedStyle("height"),10),G=H<0?Math.abs(H):-H,D=H<0?"prev":"next";F.preventDefault();if(!this._moving||this._movingDirection!=D){E.setStyle("top",0);C.setStyles({"opacity":1,"left":"auto","top":H<0?-B:B});this._moving=true;this._movingDirection=D;this.fire("moveStart",{direction:D});}E.setStyle("-webkit-transform","translate(0px, "+G+"px) translateZ(0px)");E.setStyle("-ms-transform","translate(0px, "+G+"px) translateZ(0px)");C.setStyle("-webkit-transform","translate(0px, "+G+"px) translateZ(0px)");C.setStyle("-ms-transform","translate(0px, "+G+"px) translateZ(0px)");this.fire("move");},_onEndHorizontal:function(F){if(!this._moving){return;}var B=this._startX-F.pageX,E=this.get("activeItem"),D=this.get("nextItem"),C=parseInt(D.getComputedStyle("width"),10),G=B<0?C:-C;E.transition({"transform":"translate("+G+"px, 0px)"});D.transition({"transform":"translate("+G+"px, 0px)"});setTimeout(A.bind(this._onEndComplete,this),600);this._transitioning=true;this.fire("end");},_onEndVertical:function(E){if(!this._moving){return;}var G=this._startY-E.pageY,D=this.get("activeItem"),C=this.get("nextItem"),B=parseInt(C.getComputedStyle("height"),10),F=G<0?B:-B;D.transition({"transform":"translate(0px, "+F+"px)"});C.transition({"transform":"translate(0px, "+F+"px)"});setTimeout(A.bind(this._onEndComplete,this),600);this._transitioning=true;this.fire("end");},_onEndComplete:function(){var D=this.get("direction"),C=this.get("activeItem"),B=this.get("nextItem");C.setStyles({"opacity":0,"-webkit-transform":"none","-webkit-transition":"none","-ms-transform":"none","-ms-transition":"none"});B.setStyles({"-webkit-transform":"none","-webkit-transition":"none","-ms-transform":"none","-ms-transition":"none"});if(D=="horizontal"){C.setStyle("left","-9999px");B.setStyle("left","0px");}else{C.setStyle("top","-9999px");B.setStyle("top","0px");}this.set("activeItem",B);this.set("nextItem",C);this._moving=false;this._movingDirection=null;this._transitioning=false;this.fire("endComplete");}},{ATTRS:{direction:{value:"horizontal"},activeItem:{value:null},nextItem:{value:null}}});A.namespace("FL").SlideshowImageLoader={_loading:false,_currentImage:null,_currentImageData:null,_queue:[],add:function(D,E,F,B){var C={group:D,src:E,callback:F};if(B){this._queue.unshift(C);}else{this._queue.push(C);}if(!this._loading){this._load();}},removeGroup:function(C){var B=this._queue.length-1;for(;B>-1;B--){if(this._queue[B].group==C){this._queue.splice(B,1);}}if(this._currentImageData&&this._currentImageData.group==C){this._currentImage.detachAll();this._currentImage=null;this._currentImageData=null;if(this._queue.length>0){this._load();}else{this._loading=false;}}},_load:function(){this._loading=true;this._currentImageData=this._queue.shift();this._currentImage=A.Node.create("<img />");this._currentImage.on("error",A.bind(this._loadComplete,this));this._currentImage.on("load",A.bind(this._loadComplete,this));this._currentImage.set("src",this._currentImageData.src);},_loadComplete:function(){if(this._currentImageData.callback){this._currentImageData.callback(this._currentImage);}if(this._queue.length>0){this._load();}else{this._loading=false;this._currentImage=null;this._currentImageData=null;}}};A.namespace("FL").SlideshowImage=A.Base.create("fl-slideshow-image",A.Widget,[A.WidgetChild],{_imageInfo:null,_image:null,_loading:false,_loadingURL:null,_videoButton:null,_videoBox:null,_video:null,CONTENT_TEMPLATE:null,syncUI:function(){var B=this.get("boundingBox");if(this.get("crop")){B.setStyle("overflow","hidden");B.addClass("fl-slideshow-image-cropped");}},load:function(B){this._imageInfo=B;this._loading=true;this._load();},preload:function(C,E,B){var G=this._isVideo(),F=this.get("loadVideos"),D=this.get("showVideoButton");this.unload();this.set("width",E);this.set("height",B);this._imageInfo=C;if(!G||!F||(G&&F&&D)){A.FL.SlideshowImageLoader.add(this.get("loadGroup"),this._getImageURL(),A.bind(this._imagePreloaded,this),this.get("loadPriority"));}},_imagePreloaded:function(B){this._image=B;},unload:function(){if(this._image){this._image.remove();this._image.detachAll();this._image.set("src","");this._image=null;}if(this._video){this._video.remove();this._video=null;}if(this._videoButton){this._videoButton.remove();this._videoButton=null;}if(this._videoBox){this._removeVideoBox();}this._imageInfo=null;this._loading=false;this._loadingURL=null;},resize:function(D,B){var C=parseInt(this.get("boundingBox").getComputedStyle("borderTopWidth"),10)*2,E=this.get("boundingBox");this.set("width",D-C);this.set("height",B-C);E.setStyle("width",D-C+"px");E.setStyle("height",B-C+"px");if(this._videoButton){this._positionVideoButton();}if(this._videoBox){this._loadVideo();}if(!this._loading){if(this._imageInfo){this._load();}if(this._image){this._positionImage();}}},_load:function(){var C=this.get("loadVideos"),B=this.get("showVideoButton");if(this._isVideo()&&C&&!B&&!("ontouchstart" in window)){this._loadVideo();}else{this._loadImage();}},_loadImage:function(){var B=this._getImageURL(),C=this.get("loadVideos");
if(B==this._loadingURL){return;}this._loadingURL=B;A.FL.SlideshowImageLoader.add(this.get("loadGroup"),this._loadingURL,A.bind(this._loadImageComplete,this),this.get("loadPriority"));if(this._loading){if(this._isVideo()&&C){this._insertVideoButton();}this.fire("loadStart");}},_loadImageComplete:function(B){var D=this.get("boundingBox"),C=this.get("showVideoButton");this._image=B;this._image.setStyle("visibility","hidden");this._image.addClass("fl-slideshow-image-img");this._image.detachAll();if(this._video&&!C){this._video.remove();this._video=null;}D.all("img").remove();D.append(this._image);this._setupImage();this._resizeImage();this._positionImage();this._image.setStyle("visibility","visible");this._loadingURL=null;if(this._loading){this._loading=false;this.fire("loadComplete");}},_setupImage:function(){var B=this.get("boundingBox");if(typeof this._image._node.style.msInterpolationMode!="undefined"){this._image._node.style.msInterpolationMode="bicubic";}if(this.get("protect")){B.delegate("contextmenu",this._protectImage,"img");B.delegate("mousedown",this._protectImage,"img");}},_protectImage:function(B){B.preventDefault();return false;},_resizeImage:function(){var B=parseInt(this._image.getComputedStyle("borderTopWidth"),10)*2,I=this._image.get("width"),G=this._image.get("height"),J=parseInt(this.get("boundingBox").getComputedStyle("width"),10),H=parseInt(this.get("boundingBox").getComputedStyle("height"),10),F=0,C=0,L=0,D=0,E=this.get("cropHorizontalsOnly"),K=G>I,M=false;if(this._imageInfo&&this.get("checkFilenamesForNoCrop")){M=this._imageInfo.filename.indexOf("nocrop")>-1;}if(this.get("crop")&&!(E&&K)&&!M){F=J;C=Math.round(G*J/I);if(C<H){C=H;F=Math.round(I*H/G);}}else{L=I/J;D=G/H;if(D>L){F=Math.round(I*(1/D));C=Math.round(G*(1/D));}else{F=Math.round(I*(1/L));C=Math.round(G*(1/L));}}if(!this.get("crop")&&!this.get("upsize")&&(F>I||C>G)){F=I;C=G;}F-=B;C-=B;this._image.setStyle("width",F+"px");this._image.setStyle("height",C+"px");if(!this.get("crop")&&this.get("constrainWidth")){this.set("width",F+"px");}if(!this.get("crop")&&this.get("constrainHeight")){this.set("height",C+"px");}},_positionImage:function(){var G=this.get("position").split(" "),J=G[0]===""?"center":G[0],H=G[1]===""?"center":G[1],B=0,K=0,C=parseInt(this.get("boundingBox").getComputedStyle("width"),10),I=parseInt(this.get("boundingBox").getComputedStyle("height"),10),D=parseInt(this._image.getComputedStyle("borderTopWidth"),10)*2,F=parseInt(this._image.getComputedStyle("width"),10)+D,E=parseInt(this._image.getComputedStyle("height"),10)+D;if(isNaN(F)&&isNaN(E)){return;}if(J=="left"){B=0;}if(J=="center"){B=(C-F)/2;}if(J=="right"){B=C-F;}if(H=="top"){K=0;}if(H=="center"){K=(I-E)/2;}if(H=="bottom"){K=I-E;}this._image.setStyles({"left":B,"top":K});},_getImageURL:function(){var D=0,C=0,H=0,G=this.get("width"),B=this.get("height"),E=this.get("useThumbSizes"),F=this._imageInfo,I=[F.tinyURL||F.thumbURL||F.largeURL,F.thumbURL||F.largeURL,F.smallURL||F.largeURL,F.mediumURL||F.largeURL||F.smallURL,F.largeURL||F.mediumURL||F.smallURL,F.xlargeURL||F.largeURL||F.mediumURL||F.smallURL,F.x2largeURL||F.largeURL||F.mediumURL||F.smallURL,F.x3largeURL||F.x2largeURL||F.largeURL||F.mediumURL||F.smallURL];if(E&&G<=100){D=0;}else{if(E&&G<=150){D=1;}else{if(G<=400){D=2;}else{if(G>=400&&G<=600){D=3;}else{if(G>=600&&G<=800){D=4;}else{if(G>=800&&G<=1024){D=5;}else{if(G>=1024&&G<=1280){D=6;}else{D=7;}}}}}}}if(E&&B<=100){C=0;}else{if(E&&B<=150){C=1;}else{if(B<=300){C=2;}else{if(B>=300&&B<=450){C=3;}else{if(B>=450&&B<=600){C=4;}else{if(B>=600&&B<=768){C=5;}else{if(B>=768&&B<=960){C=6;}else{C=7;}}}}}}}H=Math.max(D,C);return I[H];},_isVideo:function(){if(!this._imageInfo){return false;}else{if(this._imageInfo.format=="mp4"&&this._imageInfo.sourceType=="smugmug"){return true;}else{if(this._imageInfo.iframe!==""){return true;}}}return false;},_loadVideo:function(){var D=this.get("boundingBox"),B=this.get("showVideoButton"),C=B?true:false;if(this._video){this._video.remove();this._video=null;}if(this._imageInfo.format=="mp4"&&this._imageInfo.sourceType=="smugmug"){this._video=this._getSmugMugVideoEmbed(this._imageInfo,C);}else{if(this._imageInfo.iframe!==""){this._video=this._getIframeVideoEmbed(this._imageInfo,C);}}if(this._videoBox){this._videoBox.one(".fl-slideshow-video-wrap").insert(this._video);}else{D.all("img").remove();D.append(this._video);}if(this._loading){this._loading=false;this.fire("loadComplete");}},_insertVideoButton:function(){var C=this.get("boundingBox"),B="ontouchstart" in window?"touchstart":"click";this._videoButton=A.Node.create('<a class="fl-slideshow-video-button" href="javascript:void(0);"></a>');this._videoButton.on(B,A.bind(this._showVideoBox,this));C.insert(this._videoButton);this._positionVideoButton();},_positionVideoButton:function(){var B=this.get("width"),C=this.get("height"),E=parseInt(this._videoButton.getStyle("width"),10),D=parseInt(this._videoButton.getStyle("height"),10);this._videoButton.setStyles({left:(B-E)/2,top:(C-D)/2});},_showVideoBox:function(){var B=this.get("root"),C=A.Node.create('<div class="fl-slideshow-video-wrap"></div>'),E=A.Node.create('<a class="fl-slideshow-video-close" href="javascript:void(0);"></a>'),D="ontouchstart" in window?"touchstart":"click";this._videoBox=A.Node.create('<div class="fl-slideshow-video"></div>');this._videoBox.setStyle("padding",B.get("boundingBox").getStyle("padding"));this._videoBox.insert(C);this._videoBox.insert(E);this._videoBox.on(D,A.bind(this._removeVideoBox,this));E.on(D,A.bind(this._removeVideoBox,this));if(typeof YUI.Env.mods["sm-fonticon"]!=="undefined"){E.addClass("sm-fonticon sm-fonticon-XCrossEncircled sm-button-skin-default sm-button-nochrome");}A.one("body").insert(this._videoBox);this._loadVideo();A.one("body").on("fl-slideshow-image|keydown",this._onKey,this);},_getSmugMugVideoEmbed:function(B,C){var H=document.createElement("video"),D=0,G="",F="",E="";if(A.UA.mobile!==null&&!!H.canPlayType&&H.canPlayType("video/mp4")){D=this.get("width");G="http://www.smugmug.com/photos/"+B.id+"_"+B.key+"-"+D+".mp4";
E+='<video width="100%" height="100%" poster="'+this._getImageURL()+'" controls preload="none"';if(C){E+=" autoplay";}E+=">";E+='<source src="'+G+'" type="video/mp4" />';E+="</video>";}else{F="imageId="+B.id;F+="&amp;imageKey="+B.key;F+="&amp;albumId="+B.albumId;F+="&amp;albumKey="+B.albumKey;F+="&amp;apiURL=http://api.smugmug.com/&amp;hostLevel=live&amp;isPro=true";if(C){F+="&amp;autoPlay=true";}else{F+="&amp;autoPlay=false";}E+='<object type="application/x-shockwave-flash" width="100%" height="100%" data="http://cdn.smugmug.com/img/ria/SmugPlayer/2012102601.swf">';E+='<param name="movie" value="http://cdn.smugmug.com/img/ria/SmugPlayer/2012102601.swf">';E+='<param name="allowFullScreen" value="true">';E+='<param name="wmode" value="transparent">';E+='<param name="flashVars" value="'+F+'">';E+='<embed src="http://cdn.smugmug.com/img/ria/SmugPlayer/2012102601.swf" flashvars="'+F+'" width="100%" height="100%" type="application/x-shockwave-flash" allowfullscreen="true" wmode="transparent">';E+="</object>";}return A.Node.create(E);},_getIframeVideoEmbed:function(B,D){var E='<iframe width="100%" height="100%" frameborder="0" allowfullscreen ',C=B.iframe;if(D){C+=C.indexOf("?")>-1?"&autoplay=1":"?autoplay=1";}E+='src="'+C+'"></iframe>';return A.Node.create(E);},_removeVideoBox:function(B){if(typeof B!=="undefined"&&B.target){if(B.target.get("className").indexOf("fl-slideshow-video")<0){return;}}if(this._videoBox!==null){this._videoBox.remove();this._videoBox=null;this._video=null;}A.one("body").detach("fl-slideshow-image|keydown",this._onKey);},_onKey:function(B){if(B.keyCode==27){this._removeVideoBox();return false;}}},{CSS_PREFIX:"fl-slideshow-image",ATTRS:{loadGroup:{value:"none"},loadPriority:{value:false},crop:{value:false},checkFilenamesForNoCrop:{value:true},cropHorizontalsOnly:{value:false},position:{value:"center center"},protect:{value:true},upsize:{value:true},useThumbSizes:{value:false},constrainWidth:{value:false},constrainHeight:{value:false},loadVideos:{value:true},showVideoButton:{value:true}}});A.namespace("FL").SlideshowMouseNav=A.Base.create("fl-slideshow-mouse-nav",A.Plugin.Base,[],{initializer:function(){var B=this.get("trigger");B.on("click",this._triggerClick,this);B.on("mousemove",this._showArrow,this);B.on("mouseleave",this._hideArrow,this);},_triggerClick:function(G){var E=this.get("host"),D=this.get("trigger"),F=parseInt(D.getStyle("width"),10),B=D.get("region"),C=G.pageX-B.left+5;if(C>=F/2){E.nextImage();}else{E.prevImage();}},_showArrow:function(G){var E=this.get("host"),D=this.get("trigger"),F=parseInt(D.getStyle("width"),10),B=D.get("region"),C=G.pageX-B.left+5;if(E.albumInfo!==null&&E.albumInfo.images.length>1){if(C>=F/2){D.removeClass("fl-slideshow-mouse-nav-prev");D.addClass("fl-slideshow-mouse-nav-next");}else{D.removeClass("fl-slideshow-mouse-nav-next");D.addClass("fl-slideshow-mouse-nav-prev");}}},_hideArrow:function(){var B=this.get("trigger");B.removeClass("fl-slideshow-mouse-nav-next");B.removeClass("fl-slideshow-mouse-nav-prev");}},{NS:"mouseNav",ATTRS:{trigger:{value:null}}});A.namespace("FL").SlideshowKenBurns=A.Base.create("fl-slideshow-ken-burns",A.Base,[],{run:function(){var C=null,B=null;if(A.FL.Utils.cssSupport("transform")){C=this.get("image").one("img");B=this._getTransform();C.setStyles({"-webkit-transform-origin":B.origin,"-moz-transform-origin":B.origin,"-ms-transform-origin":B.origin,"transform-origin":B.origin,"transform":B.start});C.transition({easing:"ease-out",duration:this.get("duration"),"transform":B.end});}},_getTransform:function(){var E=this.get("zoom"),F=this.get("image"),C=0,D=null,B=null;C=Math.floor(Math.random()*A.FL.SlideshowKenBurns.ZOOM_DIRECTIONS.length);D=A.FL.SlideshowKenBurns.ZOOM_DIRECTIONS[C];C=Math.floor(Math.random()*A.FL.SlideshowKenBurns.TRANSFORMS.length);B=A.FL.SlideshowKenBurns.TRANSFORMS[C];if(!F.hasClass("fl-slideshow-image-cropped")&&D=="in"){C=Math.floor(Math.random()*2);B.start=C===0?"scale(1) translate(100px, 0)":"scale(1) translate(-100px, 0)";B.end="scale("+E+") translate(0, 0)";B.origin="center center";}else{if(D=="out"){B.start="scale("+E+") "+B.translate;B.end="scale(1) translate(0, 0)";}else{B.start="scale(1) translate(0, 0)";B.end="scale("+E+") "+B.translate;}}return B;}},{ATTRS:{image:{value:null},zoom:{value:1.2},duration:{value:2}},ZOOM_DIRECTIONS:["in","out"],TRANSFORMS:[{origin:"left top",translate:"translate(-30px, -15px)"},{origin:"left center",translate:"translate(-30px, 0)"},{origin:"left bottom",translate:"translate(-30px, 15px)"},{origin:"right top",translate:"translate(30px, -15px)"},{origin:"right center",translate:"translate(30px, 0)"},{origin:"right bottom",translate:"translate(30px, 15px)"}]});A.namespace("FL").SlideshowNav=A.Base.create("fl-slideshow-nav",A.Widget,[A.WidgetChild],{_buttons:null,_buttonsContainer:null,_buttonsLeftContainer:null,_buttonsRightContainer:null,_fontIcons:{buy:"Cart",caption:"InfoEncircled",close:"XCrossEncircled",fullscreen:"ScreenExpand",next:"ArrowRight",nextPage:"ArrowRight",pause:"PlayerPause",play:"PlayerPlay",prev:"ArrowLeft",prevPage:"ArrowLeft",social:"Heart",thumbs:"ViewThumbGrid"},CONTENT_TEMPLATE:null,renderUI:function(){this._renderContainers();this._renderButtons();this._renderFontIcons();},bindUI:function(){var B=this.get("root"),C=this.get("id");if(this._buttons.prev){this._buttons.prev.on("click",B.prevImage,B);}if(this._buttons.next){this._buttons.next.on("click",B.nextImage,B);}if(this._buttons.play){this._buttons.play.on("click",this._playClicked,this);B.on(C+"|played",this._showPauseButton,this);B.on(C+"|paused",this._showPlayButton,this);if(B._playing){this._showPauseButton();}else{this._showPlayButton();}}if(this._buttons.buy){B.on(C+"|albumLoadComplete",this._updateBuy,this);if(B.albumInfo!==null){this._updateBuy();}}if(this._buttons.count){B.on(C+"|imageLoadComplete",this._updateCount,this);}if(this._buttons.thumbs){this._buttons.thumbs.on("click",B._toggleThumbs,B);}if(this._buttons.caption){B.on(C+"|imageLoadComplete",this._updateCaption,this);
this._updateCaption();}if(this._buttons.social){this._buttons.social.on("click",B._toggleSocial,B);}if(this._buttons.fullscreen&&B.fullscreen){this._buttons.fullscreen.on("click",B.fullscreen.toggle,B.fullscreen);}if(this._buttons.close){this._buttons.close.on("click",B.hide,B);}},destructor:function(){var B=this.get("root"),C=this.get("id");B.detach(C+"|*");},_renderContainers:function(){var B=this.get("contentBox"),C=this.get("buttonsLeft"),D=this.get("buttonsRight");this._buttonsContainer=A.Node.create("<div></div>");this._buttonsContainer.addClass("fl-slideshow-nav-buttons");B.appendChild(this._buttonsContainer);if(C.length>0){this._buttonsLeftContainer=A.Node.create("<div></div>");this._buttonsLeftContainer.addClass("fl-slideshow-nav-buttons-left");B.appendChild(this._buttonsLeftContainer);}if(D.length>0){this._buttonsRightContainer=A.Node.create("<div></div>");this._buttonsRightContainer.addClass("fl-slideshow-nav-buttons-right");B.appendChild(this._buttonsRightContainer);}},_renderButtons:function(){var D="",E=0,C=0,B=[{names:this.get("buttons"),container:this._buttonsContainer},{names:this.get("buttonsLeft"),container:this._buttonsLeftContainer},{names:this.get("buttonsRight"),container:this._buttonsRightContainer}];this._buttons={};for(;E<B.length;E++){for(C=0;C<B[E].names.length;C++){D=B[E].names[C];if(D.indexOf("count")>-1){this._buttons[D]=A.Node.create("<span></span>");this._updateCount();}else{this._buttons[D]=A.Node.create('<a href="javascript:void(0);"></a>');}if(D.indexOf("buy")>-1){this._buttons[D].setStyle("display","none");}this._buttons[D].set("name",D);this._buttons[D].addClass("fl-slideshow-nav-"+D);B[E].container.appendChild(this._buttons[D]);}}},_renderFontIcons:function(){var B=null;if(this.get("useFontIcons")&&typeof YUI.Env.mods["sm-fonticon"]!=="undefined"){for(B in this._buttons){if(typeof this._buttons[B]!=="undefined"&&typeof this._fontIcons[B]!=="undefined"){this._buttons[B].addClass("sm-fonticon-"+this._fontIcons[B]);this._buttons[B].addClass("sm-fonticon sm-button-skin-default sm-button-nochrome");}else{if(B.indexOf("count")>-1){this._buttons[B].addClass("fonticons-enabled");}}}}},_updateCount:function(){var C="",B=A.FL.SlideshowNav.COUNT_TEXT,E=1,D=1;if(this.get("root").albumInfo){E=this.get("root").imageInfo.index+1;D=this.get("root").albumInfo.images.length;}C=B.replace("{current}",E).replace("{total}",D);this._buttons.count.set("innerHTML",C);},_updateCaption:function(){var C=this.get("root"),B=C.imageInfo;if(B&&B.caption===""){C.caption.slideshowOverlay.enable();C.caption.slideshowOverlay.hide();this._buttons.caption.detach("click");this._buttons.caption.addClass("fl-slideshow-nav-caption-disabled");}else{this._buttons.caption.on("click",C._toggleCaption,C);this._buttons.caption.removeClass("fl-slideshow-nav-caption-disabled");}},_updateBuy:function(){var F=null,C=this.get("root"),B=C.get("source")[C.albumIndex],D=C.albumIndex,E=C.get("source")[D];if(B&&B.type=="smugmug"){if(typeof C.albumInfo.printable!=="undefined"){this._updateBuyComplete();}else{F=new A.FL.SmugMugAPI();F.addParam("method","smugmug.albums.getInfo");F.addParam("AlbumID",E.id);F.addParam("AlbumKey",E.key);F.on("complete",this._updateBuyComplete,this);F.request();}}},_updateBuyComplete:function(D){var B=this.get("root"),E=typeof D=="undefined"?B.albumInfo.printable:D.Album.Printable,C=B.albumInfo.link;if(E){B.albumInfo.printable=true;this._buttons.buy.set("href","https://secure.smugmug.com/cart/batchadd/?url="+encodeURIComponent(C));this._buttons.buy.setStyle("display","inline-block");}else{B.albumInfo.printable=false;this._buttons.buy.setStyle("display","none");}this.fire("resize");},_playClicked:function(){var B=this.get("root");if(B._playing){B.pause();}else{B.play();}},_showPlayButton:function(){this._buttons.play.removeClass("fl-slideshow-nav-pause");this._buttons.play.addClass("fl-slideshow-nav-play");if(this.get("useFontIcons")&&typeof YUI.Env.mods["sm-fonticon"]!=="undefined"){this._buttons.play.removeClass("sm-fonticon-PlayerPause");this._buttons.play.addClass("sm-fonticon-PlayerPlay");}},_showPauseButton:function(){this._buttons.play.removeClass("fl-slideshow-nav-play");this._buttons.play.addClass("fl-slideshow-nav-pause");if(this.get("useFontIcons")&&typeof YUI.Env.mods["sm-fonticon"]!=="undefined"){this._buttons.play.removeClass("sm-fonticon-PlayerPlay");this._buttons.play.addClass("sm-fonticon-PlayerPause");}}},{CSS_PREFIX:"fl-slideshow-nav",COUNT_TEXT:"{current} of {total}",ATTRS:{buttons:{value:[],writeOnce:true},buttonsLeft:{value:[],writeOnce:true},buttonsRight:{value:[],writeOnce:true},useFontIcons:{value:true,writeOnce:true}}});A.namespace("FL").SlideshowOverlay=A.Base.create("fl-slideshow-overlay",A.Plugin.Base,[],{_focus:false,_visible:true,_disabled:false,_showProps:{duration:0.5,easing:"ease-out",opacity:1},_hideProps:{duration:0.5,easing:"ease-out",opacity:0},_hideTimer:null,initializer:function(){var B=this.get("host").get("boundingBox");this.afterHostEvent("render",this._initFocus);this.afterHostEvent("render",this._initVisibility);if(this.get("closeButton")){this._initCloseButton();}B.addClass("fl-slideshow-overlay");},destructor:function(){this._hideTimerCancel();},_initFocus:function(){var B=this.get("host").get("boundingBox");B.on("mouseenter",A.bind(this._setFocusOnMouseenter,this));B.on("mouseleave",A.bind(this._setFocusOnMouseleave,this));},_initVisibility:function(){var C=this.get("host").get("boundingBox"),B=this.get("hideStyle");if(!this.get("visible")){if(B=="display"){C.setStyle("display","none");}else{if(B=="left"){C.setStyle("left","-99999px");}}C.setStyle("opacity","0");this._visible=false;}},_initCloseButton:function(){var C=this.get("host").get("boundingBox"),B=null;B=A.Node.create('<a class="fl-slideshow-overlay-close" href="javascript:void(0);"></a>');B.on("click",A.bind(this._closeButtonClick,this));if(typeof YUI.Env.mods["sm-fonticon"]!=="undefined"){B.addClass("sm-fonticon sm-fonticon-XCrossEncircled sm-button-skin-default sm-button-nochrome");
}C.insert(B);},_closeButtonClick:function(){var B=this.get("host").get("boundingBox");B.transition(this._hideProps,A.bind(this._hideComplete,this));},_setFocusOnMouseenter:function(){this._focus=true;},_setFocusOnMouseleave:function(){this._focus=false;},disable:function(){this._disabled=true;},enable:function(){this._disabled=false;},show:function(){var C=this.get("host").get("boundingBox"),B=this.get("hideStyle");if(this._disabled){return;}if(B=="display"){C.setStyle("display","block");}else{if(B=="left"){C.setStyle("left","auto");}}C.transition(this._showProps,A.bind(this._showComplete,this));this.fire("showStart");},_showComplete:function(){this._visible=true;this.hideWithTimer();this.fire("showComplete");},hide:function(){if(this._focus||this._disabled){return;}var B=this.get("host").get("boundingBox");B.transition(this._hideProps,A.bind(this._hideComplete,this));this.fire("hideStart");},hideWithTimer:function(){this._hideTimerCancel();this._hideTimer=A.later(this.get("hideDelay"),this,this.hide);},_hideTimerCancel:function(){if(this._hideTimer){this._hideTimer.cancel();this._hideTimer=null;}},_hideComplete:function(){var C=this.get("host").get("boundingBox"),B=this.get("hideStyle");if(B=="display"){C.setStyle("display","none");}else{if(B=="left"){C.setStyle("left","-99999px");}}this._visible=false;this.fire("hideComplete");}},{NS:"slideshowOverlay",ATTRS:{closeButton:{value:false,writeOnce:true},hideDelay:{value:3000,writeOnce:true},hideStyle:{value:"display",writeOnce:true},visible:{value:true,writeOnce:true}}});A.namespace("FL").SlideshowSocial=A.Base.create("fl-slideshow-social",A.Widget,[A.WidgetChild],{_buttons:null,renderUI:function(){this._buttons={};if(this.get("root").get("googlePlusButtonEnabled")){this._renderGooglePlusButton();}},bindUI:function(){var B=this.get("root");if(B.get("likeButtonEnabled")){B.on("imageLoadComplete",A.bind(this._updateLikeButton,this));}if(B.get("tweetButtonEnabled")){B.on("imageLoadComplete",A.bind(this._updateTweetButton,this));}if(B.get("googlePlusButtonEnabled")){B.on("imageLoadComplete",A.bind(this._updateGooglePlusButton,this));}if(B.get("pinterestButtonEnabled")){B.on("imageLoadComplete",A.bind(this._updatePinterestButton,this));}},_updateLikeButton:function(){var G=null,C=this.get("contentBox"),E=this.get("root"),F=E.albumIndex,D=E.get("source")[F],B=E.imageInfo;if(this._buttons.like){this._buttons.like.remove();this._buttons.like=null;}if(D.type=="smugmug"){G="http://www.facebook.com/plugins/like.php?";G+="href="+"http://www.smugmug.com/services/graph/gallery/";G+=D.id+"_"+D.key+"/"+B.id+"_"+B.key;}else{G="http://www.facebook.com/plugins/like.php?";G+="href="+encodeURIComponent(B.largeURL);}G+="&send=false";G+="&layout=button_count";G+="&width=90";G+="&show_faces=false";G+="&action=like";G+="&colorscheme=light";G+="&height=21";this._buttons.like=A.Node.create('<iframe src="'+G+'" scrolling="no" frameborder="0" allowTransparency="true"></iframe>');this._buttons.like.setStyles({overflow:"hidden",width:"90px",height:"21px"});C.appendChild(this._buttons.like);},_updateTweetButton:function(){var D=null,C=this.get("root").imageInfo,B=this.get("contentBox");if(this._buttons.tweet){this._buttons.tweet.remove();this._buttons.tweet=null;}D="https://platform.twitter.com/widgets/tweet_button.html?";D+="url="+encodeURIComponent(C.largeURL);D+="&count=none";this._buttons.tweet=A.Node.create('<iframe src="'+D+'" scrolling="no" frameborder="0" allowTransparency="true"></iframe>');this._buttons.tweet.setStyles({overflow:"hidden",width:"90px",height:"21px"});B.appendChild(this._buttons.tweet);},_renderGooglePlusButton:function(){var B,C;B=document.createElement("script");B.type="text/javascript";B.src="https://apis.google.com/js/plusone.js";C=document.getElementsByTagName("head")[0];C.parentNode.appendChild(B);},_updateGooglePlusButton:function(){if(typeof gapi=="undefined"){setTimeout(A.bind(this._updateGooglePlusButtonCallback,this),500);}else{this._updateGooglePlusButtonCallback();}},_updateGooglePlusButtonCallback:function(){var C=this.get("root").imageInfo,B=this.get("contentBox");if(this._buttons.plus){this._buttons.plus.remove();this._buttons.plus=null;}if(typeof gapi!="undefined"){this._buttons.plus=A.Node.create("<div></div>");B.appendChild(this._buttons.plus);gapi.plusone.render(this._buttons.plus._node,{href:encodeURIComponent(C.largeURL),annotation:"bubble",size:"medium"});}},_updatePinterestButton:function(){var D="http://pinterest.com/pin/create/button/",C=this.get("root").imageInfo,B=this.get("contentBox");if(this._buttons.pin){this._buttons.pin.remove();this._buttons.pin=null;}D+="?url="+encodeURIComponent(window.location.href);D+="&media="+encodeURIComponent(C.mediumURL);D+="&description="+encodeURIComponent(C.caption);this._buttons.pin=A.Node.create("<a></a>");this._buttons.pin.setAttribute("data-pin-config","none");this._buttons.pin.setAttribute("data-pin-do","buttonPin");this._buttons.pin.setAttribute("href",D);this._buttons.pin.setAttribute("target","_blank");this._buttons.pin.set("innerHTML",'<img src="http://assets.pinterest.com/images/pidgets/pin_it_button.png" border="0" />');B.appendChild(this._buttons.pin);}},{CSS_PREFIX:"fl-slideshow-social",ATTRS:{}});A.namespace("FL").SlideshowThumbs=A.Base.create("fl-slideshow-thumbs",A.Widget,[A.WidgetParent,A.WidgetChild],{_clipBox:null,_pagesBox:null,_activePageBox:null,_activePageIndex:0,_nextPageBox:null,_activeImages:null,_nextImages:null,_prevImages:null,_leftNav:null,_rightNav:null,_topNav:null,_bottomNav:null,_bbHeight:0,_bbWidth:0,_cbWidth:0,_clipBoxMarginLeft:0,_clipBoxTop:0,_colsPerPage:0,_rowsPerPage:0,_imagesPerPage:0,_numPages:0,_pageHeight:0,_pageWidth:0,_horizontalSpacing:0,_verticalSpacing:0,_leftNavWidth:0,_rightNavWidth:0,_transition:null,_transitioning:false,_transitionDirection:"next",_gestures:null,initializer:function(){this._activeImages=[];this._nextImages=[];this._prevImages=[];},renderUI:function(){this._renderBoxes();this._renderNavs();},bindUI:function(){var B=this.get("root"),D=this.get("id"),C=this.get("transition");
B.on(D+"|albumLoadComplete",this._albumLoadComplete,this);if("ontouchstart" in window&&this.get("touchSupport")){this._gestures=new A.FL.SlideshowGestures({direction:C=="slideVertical"?"vertical":"horizontal",activeItem:this._activePageBox,nextItem:this._nextPageBox});this._gestures.on("moveStart",this._gesturesMoveStart,this);this._gestures.on("endComplete",this._gesturesEndComplete,this);}},syncUI:function(){this._syncBoxes();this._syncNavs();},destructor:function(){var B=this.get("root"),C=this.get("id");B.detach(C+"|*");A.FL.SlideshowImageLoader.removeGroup("thumbs");},unload:function(){var B=this.get("root"),D=this.get("id"),C=0;B.detach(D+"|imageLoadComplete");A.FL.SlideshowImageLoader.removeGroup("thumbs");for(;C<this._activeImages.length;C++){this._activeImages[C].unload();}},resize:function(){this._setSizeInfo();this._togglePageButtons();this._resizeBoxes();this._resizeNavs();if(this.get("root").albumInfo){A.FL.SlideshowImageLoader.removeGroup("thumbs");this._renderActivePage();this._preloadNextPage();this._preloadPrevPage();}if(this._gestures&&this._numPages<2){this._gestures.disable();}else{if(this._gestures){this._gestures.enable();}}},prevPage:function(){if(this._transitioning){return;}this._transitionStart("prev");},nextPage:function(){if(this._transitioning){return;}this._transitionStart("next");},_albumLoadComplete:function(){var B=this.get("root"),C=this.get("id");B.once(C+"|imageLoadComplete",this.resize,this);B.on(C+"|imageLoadComplete",this._imageLoadComplete,this);},_imageLoadComplete:function(){var B=this.get("root").albumInfo,E=A.one(".fl-slideshow-image-active"),F=E?E._imageInfo:null,D=null,C=this.get("root").imageInfo;this._setActiveImage(this._activeImages);D=A.one(".fl-slideshow-image-active");if(E&&!D){if(C.index===0&&F.index===B.images.length-1){this.nextPage();}else{if(F.index===0&&C.index===B.images.length-1){this.prevPage();}else{if(F.index<C.index){this.nextPage();}else{if(F.index>C.index){this.prevPage();}}}}}},_renderBoxes:function(){this._clipBox=A.Node.create("<div></div>");this._clipBox.addClass("fl-slideshow-thumbs-clip");this.get("contentBox").insert(this._clipBox);this._pagesBox=A.Node.create("<div></div>");this._pagesBox.addClass("fl-slideshow-thumbs-pages");this._clipBox.insert(this._pagesBox);this._activePageBox=A.Node.create("<div></div>");this._activePageBox.addClass("fl-slideshow-thumbs-page");this._pagesBox.insert(this._activePageBox);this._nextPageBox=A.Node.create("<div></div>");this._nextPageBox.addClass("fl-slideshow-thumbs-page");this._pagesBox.insert(this._nextPageBox);},_syncBoxes:function(){this._activePageBox.setStyle("left","0");this._nextPageBox.setStyle("left","-9999px");},_resizeBoxes:function(){this.set("width",this._bbWidth);this.set("height",this._bbHeight);this.get("contentBox").setStyle("width",this._cbWidth+"px");this._clipBox.setStyle("width",this._pageWidth+"px");this._clipBox.setStyle("height",this._pageHeight+"px");this._clipBox.setStyle("padding",this._verticalSpacing+"px 0 0 "+this._horizontalSpacing+"px ");this._clipBox.setStyle("margin","0 0 0 "+this._clipBoxMarginLeft+"px");this._clipBox.setStyle("top",this._clipBoxTop);this._pagesBox.setStyle("width",this._pageWidth+"px");this._pagesBox.setStyle("height",this._pageHeight+"px");this._activePageBox.setStyle("width",this._pageWidth+"px");this._activePageBox.setStyle("height",this._pageHeight+"px");this._nextPageBox.setStyle("width",this._pageWidth+"px");this._nextPageBox.setStyle("height",this._pageHeight+"px");},_renderActivePage:function(){var E=0,D=this.get("root"),C=this._imagesPerPage*this._activePageIndex,F=C+this._imagesPerPage,B=D.albumInfo.images;this._clearActiveImage();for(;E<this._activeImages.length;E++){this._activeImages[E].remove();this._activeImages[E].unload();this._activeImages[E].get("boundingBox")._imageInfo=null;this._activeImages[E].get("boundingBox").remove();}for(E=0;C<F;C++){if(!B[C]){break;}this._renderImage(this._activeImages,E,this._activePageBox,B[C]);E++;}this._setActiveImage(this._activeImages);},_renderNextPage:function(){var B=0,C=this._transitionDirection=="next"?this._nextImages:this._prevImages;this._nextPageBox.get("children").remove();for(;B<C.length;B++){if(C[B]._imageInfo){this._renderImage(C,B,this._nextPageBox,C[B]._imageInfo);}else{break;}}this._setActiveImage(C);},_preloadNextPage:function(){var B=this._activePageIndex+1>=this._numPages?0:this._activePageIndex+1;this._preloadPage(B,this._nextImages);},_preloadPrevPage:function(){var B=this._activePageIndex-1<0?this._numPages-1:this._activePageIndex-1;this._preloadPage(B,this._prevImages);},_preloadPage:function(E,D){var F=0,I=this.get("root"),H=I.albumInfo.images,C=E*this._imagesPerPage,G=C+this._imagesPerPage,J=this.get("imageConfig"),B=J.width,K=J.height;if(this._numPages>1){for(;F<D.length;F++){D[F].remove();D[F].unload();}for(F=0;C<G;C++){if(!H[C]){continue;}this._renderImage(D,F);D[F].preload(H[C],B,K);F++;}}},_renderImage:function(G,E,F,B){var C=null,D=this.get("imageConfig");if(typeof G[E]=="undefined"){D.loadGroup="thumbs";D.useThumbSizes=true;D.loadVideos=false;G[E]=new A.FL.SlideshowImage(D);C=G[E].get("boundingBox");C.on("click",this._imageClick,this);C.on("mouseover",this._imageMouseover,this);C.on("mouseout",this._imageMouseout,this);}C=G[E].get("boundingBox");C.setStyle("margin","0 "+this._horizontalSpacing+"px "+this._verticalSpacing+"px 0");if(F){this._childrenContainer=F;this.add(G[E]);G[E].resize(D.width,D.height);}if(B){G[E].load(B);C._imageInfo=B;}},_uiAddChild:function(C,B){C.render(B);B.appendChild(C.get("boundingBox"));},_imageClick:function(C){var B=this.get("root");if(this.get("pauseOnClick")){B.pause();}B.loadImage(C.currentTarget._imageInfo.index);this.fire("imageClick");},_setActiveImage:function(C){var B=0;this._clearActiveImage();for(;B<C.length;B++){if(C[B]._imageInfo){if(C[B]._imageInfo.index==this.get("root").imageInfo.index){C[B].get("boundingBox").addClass("fl-slideshow-image-active");break;}}}},_clearActiveImage:function(){var B=A.one(".fl-slideshow-image-active");
if(B){B.removeClass("fl-slideshow-image-active");}},_getTransition:function(){var B=this.get("transition");if(B=="slideHorizontal"&&this._transitionDirection=="next"){return"slideLeft";}else{if(B=="slideHorizontal"&&this._transitionDirection=="prev"){return"slideRight";}else{if(B=="slideVertical"&&this._transitionDirection=="next"){return"slideUp";}else{if(B=="slideVertical"&&this._transitionDirection=="prev"){return"slideDown";}}}}return B;},_transitionStart:function(B){if(this._numPages>1){A.FL.SlideshowImageLoader.removeGroup("thumbs");this._transitionDirection=B;this._transitioning=true;this._nextPageBox.setStyle("left","0px");this._renderNextPage();this._transition=new A.FL.SlideshowTransition({itemIn:this._nextPageBox,itemOut:this._activePageBox,type:this._getTransition(),duration:this.get("transitionDuration"),easing:this.get("transitionEasing")});this._transition.once("complete",this._transitionComplete,this);this._transition.run();if(this._gestures){this._gestures.disable();}}},_transitionComplete:function(){this._swapPageRefs();this._transitioning=false;this._transitionDirection="";this._transition=null;if(this._gestures){this._gestures.enable();}this.fire("transitionComplete");},_gesturesMoveStart:function(B){A.FL.SlideshowImageLoader.removeGroup("thumbs");this._transitionDirection=B.direction;this._renderNextPage();},_gesturesEndComplete:function(){this._swapPageRefs();this._transitionDirection="";this.fire("transitionComplete");},_swapPageRefs:function(){var B=this._activePageBox,C=this._activeImages;this._activePageBox=this._nextPageBox;this._nextPageBox=B;this._nextPageBox.setStyle("left","-9999px");if(this._transitionDirection=="next"){this._activeImages=this._nextImages;this._nextImages=C;}else{this._activeImages=this._prevImages;this._prevImages=C;}if(this._transitionDirection=="next"&&this._activePageIndex+1<this._numPages){this._activePageIndex++;}else{if(this._transitionDirection=="next"){this._activePageIndex=0;}else{if(this._transitionDirection=="prev"&&this._activePageIndex-1>-1){this._activePageIndex--;}else{if(this._transitionDirection=="prev"){this._activePageIndex=this._numPages-1;}}}}if(this._gestures){this._gestures.set("activeItem",this._activePageBox);this._gestures.set("nextItem",this._nextPageBox);}this._preloadNextPage();this._preloadPrevPage();},_renderNavs:function(){var D=this.get("topNavButtons"),C=this.get("rightNavButtons"),B=this.get("bottomNavButtons"),E=this.get("leftNavButtons");if(this.get("topNavEnabled")&&D.length>0){this._topNav=new A.FL.SlideshowNav({buttons:D});this._topNav.get("boundingBox").addClass("fl-slideshow-thumbs-top-nav");this.add(this._topNav);this._topNav.render(this.get("contentBox"));this._clipBox.insert(this._topNav.get("boundingBox"),"before");this._bindNavEvents(this._topNav);}if(this.get("rightNavEnabled")&&C.length>0){this._rightNav=new A.FL.SlideshowNav({buttons:C});this._rightNav.get("boundingBox").addClass("fl-slideshow-thumbs-right-nav");this.add(this._rightNav);this._rightNav.render(this.get("contentBox"));this._bindNavEvents(this._rightNav);}if(this.get("bottomNavEnabled")&&B.length>0){this._bottomNav=new A.FL.SlideshowNav({buttons:B});this._bottomNav.get("boundingBox").addClass("fl-slideshow-thumbs-bottom-nav");this.add(this._bottomNav);this._bottomNav.render(this.get("contentBox"));this._bindNavEvents(this._bottomNav);}if(this.get("leftNavEnabled")&&E.length>0){this._leftNav=new A.FL.SlideshowNav({buttons:E});this._leftNav.get("boundingBox").addClass("fl-slideshow-thumbs-left-nav");this.add(this._leftNav);this._leftNav.render(this.get("contentBox"));this._bindNavEvents(this._leftNav);}},_syncNavs:function(){var D,B,C;if(this._rightNav){D=this._rightNav.get("boundingBox");D.setStyle("position","absolute");D.setStyle("top","0px");D.setStyle("right","0px");}if(this._bottomNav){B=this._bottomNav.get("boundingBox");B.setStyle("position","absolute");B.setStyle("bottom","0px");B.setStyle("width","100%");}if(this._leftNav){C=this._leftNav.get("boundingBox");C.setStyle("position","absolute");C.setStyle("top","0px");C.setStyle("left","0px");}},_resizeNavs:function(){var D,C,B;if(this._rightNav){D=this._rightNav.get("boundingBox");B=this._bbHeight/2-parseInt(D.getComputedStyle("height"),10)/2;D.setStyle("marginTop",B+"px");}if(this._leftNav){C=this._leftNav.get("boundingBox");B=this._bbHeight/2-parseInt(C.getComputedStyle("height"),10)/2;C.setStyle("marginTop",B+"px");}},_bindNavEvents:function(B){if(B._buttons.prevPage){B._buttons.prevPage.on("click",this.prevPage,this);}if(B._buttons.nextPage){B._buttons.nextPage.on("click",this.nextPage,this);}B.on("resize",this.resize,this);},_togglePageButtons:function(){var B=this.get("boundingBox").all(".fl-slideshow-nav-prevPage, .fl-slideshow-nav-nextPage"),C=B.getStyle("display")[0];if(this._numPages==1&&C=="inline-block"){B.setStyle("display","none");this._setSizeInfo();}else{if(this._numPages>1&&C=="none"){B.setStyle("display","inline-block");this._setSizeInfo();}}},_setSizeInfo:function(){var V=this.get("root"),k=this.get("boundingBox"),L=k.getStyle("position"),J=parseInt(k.getStyle("marginLeft"),10),B=parseInt(k.getStyle("marginRight"),10),X=parseInt(k.getStyle("marginTop"),10),I=parseInt(k.getStyle("marginBottom"),10),m=parseInt(k.getStyle("paddingLeft"),10),c=parseInt(k.getStyle("paddingRight"),10),i=parseInt(k.getStyle("paddingTop"),10),f=parseInt(k.getStyle("paddingBottom"),10),F=k.get("parentNode"),Q=parseInt(F.getComputedStyle("width"),10),d=parseInt(F.getComputedStyle("height"),10),Y=Q-m-c-J-B,T=d-i-f-X-I,Z=Y,R=Y,P=T,G=this.get("columns"),h=this.get("rows"),K=this.get("imageConfig"),C=this.get("horizontalSpacing"),O=this.get("verticalSpacing"),H=this.get("spaceEvenly"),W=this.get("centerSinglePage"),j=0,U=0,e=0,S=0,M=G,a=h,D=0,l=1,b=0,g=0,E=0,N=0;k.setStyle("position","relative");if(!isNaN(G)){Y=R=G*(K.width+C)+C;}if(!isNaN(h)){T=P=h*(K.height+O)+O;}if(this._leftNav){j=parseInt(this._leftNav.get("boundingBox").getComputedStyle("width"),10);if(isNaN(G)){R-=j;}else{Y+=j;
}}if(this._rightNav){U=parseInt(this._rightNav.get("boundingBox").getComputedStyle("width"),10);if(isNaN(G)){R-=U;}else{Y+=U;}}if(this._topNav){e=parseInt(this._topNav.get("boundingBox").getComputedStyle("height"),10);if(isNaN(h)){P-=e;}else{T+=e;}}if(this._bottomNav){S=parseInt(this._bottomNav.get("boundingBox").getComputedStyle("height"),10);if(isNaN(h)){P-=S;}else{T+=S;}}if(isNaN(G)){M=Math.floor(R/(K.width+C));M=M<1?1:M;}if(isNaN(h)){a=Math.floor(P/(K.height+O));a=a<1?1:a;}D=M*a;if(V.albumInfo){l=Math.ceil(V.albumInfo.images.length/D);}if(isNaN(G)&&H){C=Math.floor((R-(K.width*M))/(M+1));}if(isNaN(h)&&H){O=Math.floor((P-(K.height*a))/(a+1));}if(V.albumInfo&&W&&l==1&&a==1){Z=V.albumInfo.images.length*K.width;Z+=C*(V.albumInfo.images.length+1);if(this._leftNav){Z+=j;}if(this._rightNav){Z+=U;}}else{Z=Y;}if(V.albumInfo&&W&&l==1&&a==1){R=V.albumInfo.images.length*K.width;R+=C*V.albumInfo.images.length;}else{R=M*(K.width+C);}P=a*(K.height+O);if(l<2){b=j;}else{E=Y;if(this._rightNav){E-=U;}if(this._leftNav){E-=j;b=j+(E-R-C)/2;}else{b=(E-R-C)/2;}}if(l>1&&!H){N=T;if(this._topNav){N-=e;}if(this._bottomNav){N-=S;}g=(N-(O+P))/2;}this._bbHeight=T;this._bbWidth=Y;this._cbWidth=Z;this._clipBoxMarginLeft=b;this._clipBoxTop=g;this._colsPerPage=M;this._rowsPerPage=a;this._imagesPerPage=D;this._numPages=l;this._pageHeight=P;this._pageWidth=R;this._leftNavWidth=j;this._rightNavWidth=U;this._horizontalSpacing=C;this._verticalSpacing=O;this._activePageIndex=Math.floor(V.imageIndex/this._imagesPerPage);k.setStyle("position",L);}},{CSS_PREFIX:"fl-slideshow-thumbs",ATTRS:{columns:{value:"auto"},rows:{value:"auto"},horizontalSpacing:{value:15},verticalSpacing:{value:15},spaceEvenly:{value:true},centerSinglePage:{value:true},pauseOnClick:{value:false},transition:{value:"slideHorizontal"},transitionDuration:{value:0.8},transitionEasing:{value:"ease-out"},imageConfig:{value:{crop:true,width:50,height:50}},topNavEnabled:{value:false},topNavButtons:{value:["prevPage","nextPage"]},rightNavEnabled:{value:true},rightNavButtons:{value:["nextPage"]},bottomNavEnabled:{value:false},bottomNavButtons:{value:["prevPage","nextPage"]},leftNavEnabled:{value:true},leftNavButtons:{value:["prevPage"]},touchSupport:{value:false}}});A.namespace("FL").SlideshowTransition=A.Base.create("fl-slideshow-transition",A.Base,[],{_transitionFunction:"_transitionFade",_type:"fade",initializer:function(){var D=this.get("type"),I=[],C=A.FL.SlideshowTransition.TYPES,E=A.FL.SlideshowTransition.SLIDESHOW_IMAGE_TYPES,H=A.Array.indexOf(E,D)>-1,B=this._isSlideshowImage(),G=this.get("itemIn"),F=this.get("itemOut");if(D.indexOf(",")>-1){I=D.split(",");I.sort(function(){return 0.5-Math.random();});D=I[0];}if(!B&&H){D="fade";}else{if(B){if((G&&G.one("img")===null)||(F&&F.one("img")===null)){D="none";}else{if(H){if((A.UA.gecko&&A.UA.gecko<5)||A.UA.opera>0||(A.UA.ie>0&&A.UA.ie<9)){D="fade";}}}}}if(A.FL.SlideshowTransition.TYPES[D]){this._transitionFunction=C[D];this._type=D;}this._setupItems();},run:function(){this.fire("start");this[this._transitionFunction].call(this);},_setupItems:function(){var C=this.get("itemIn"),B=this.get("itemOut");if(C){C.setStyle("zIndex",2);C.setStyle("opacity",1);if(A.FL.Utils.cssSupport("transform")){C.setStyle("transform","translate(0, 0)");}else{C.setStyle("top","0");C.setStyle("left","0");}}if(B){B.setStyle("zIndex",1);}},_isSlideshowImage:function(){var C=this.get("itemIn"),B=this.get("itemOut");if(C&&C.hasClass("fl-slideshow-image")){return true;}else{if(B&&B.hasClass("fl-slideshow-image")){return true;}}return false;},_transitionStart:function(I,B){var H=this.get("itemIn"),F=this.get("itemOut"),E=A.bind(this._transitionComplete,this),D=!H?E:null,C=this.get("duration"),G=this.get("easing");if(H){I.duration=I.duration||C;I.easing=I.easing||G;H.transition(I);}if(F){B.duration=B.duration||C;B.easing=B.easing||G;F.transition(B);}if(E){A.later(I.duration*1000+100,null,E);}else{if(D){A.later(B.duration*1000+100,null,D);}}},_transitionComplete:function(){this._set("itemIn",null);this._set("itemOut",null);this.fire("complete");},_transitionNone:function(){var C=this.get("itemIn"),B=this.get("itemOut");if(C){C.setStyle("opacity",1);}if(B){B.setStyle("opacity",0);}this._transitionComplete();},_transitionFade:function(){var B=this.get("itemIn");if(B){B.setStyle("opacity",0);}this._transitionStart({opacity:1},{opacity:0});},_transitionSlideLeft:function(){if(A.FL.Utils.cssSupport("transform")){this._cssTransitionSlide({inStart:"translate(100%, 0)",inEnd:"translate(0, 0)",outStart:"translate(0, 0)",outEnd:"translate(-100%, 0)"});}else{this._jsTransitionSlide("left");}},_transitionSlideRight:function(){if(A.FL.Utils.cssSupport("transform")){this._cssTransitionSlide({inStart:"translate(-100%, 0)",inEnd:"translate(0, 0)",outStart:"translate(0, 0)",outEnd:"translate(100%, 0)"});}else{this._jsTransitionSlide("right");}},_transitionSlideUp:function(){if(A.FL.Utils.cssSupport("transform")){this._cssTransitionSlide({inStart:"translate(0, 100%)",inEnd:"translate(0, 0)",outStart:"translate(0, 0)",outEnd:"translate(0, -100%)"});}else{this._jsTransitionSlide("up");}},_transitionSlideDown:function(){if(A.FL.Utils.cssSupport("transform")){this._cssTransitionSlide({inStart:"translate(0, -100%)",inEnd:"translate(0, 0)",outStart:"translate(0, 0)",outEnd:"translate(0, 100%)"});}else{this._jsTransitionSlide("down");}},_jsTransitionSlide:function(B){var E=this.get("itemIn"),C=this.get("itemOut"),D=0;if(C&&B=="left"){D=-parseInt(C.getStyle("width"),10);}if(C&&B=="right"){D=parseInt(C.getStyle("width"),10);}if(C&&B=="up"){D=-parseInt(C.getStyle("height"),10);}if(C&&B=="down"){D=parseInt(C.getStyle("height"),10);}if(E){E.setStyle("opacity",1);}if(E&&B=="left"){E.setStyle("left",E.getStyle("width"));}if(E&&B=="right"){E.setStyle("left","-"+E.getStyle("width"));}if(E&&B=="up"){E.setStyle("top",E.getStyle("height"));}if(E&&B=="down"){E.setStyle("top","-"+E.getStyle("height"));}if(B=="left"||B=="right"){this._transitionStart({left:0},{left:D});}else{this._transitionStart({top:0},{top:D});
}},_cssTransitionSlide:function(E){var G=this.get("itemIn"),F=this.get("itemOut"),C=A.UA.chrome<36?"transform":"-webkit-transform",D={},B={};D[C]=E.inEnd;B[C]=E.outEnd;if(G){G.setStyle("transition","");G.setStyle("opacity",1);G.setStyle(C,E.inStart);}if(F){F.setStyle("transition","");F.setStyle(C,E.outStart);}this._transitionStart(D,B);},_transitionBars:function(){this.get("itemIn").one(".fl-slideshow-image-img").setStyle("opacity",0);var D=this.get("bars"),I=this._renderSlices(1,D),B=this.get("duration"),E=0,H=100,J=false,C=0,G=null,F={duration:B,opacity:1};if(this._type=="barsRandom"){I=this._randomizeSlices(I);}for(;C<I.length;C++){G=A.clone(F);if(this._type=="blinds"){G.width=parseFloat(I[C].getComputedStyle("width"),10)+"px";I[C].setStyle("width","0px");H=50;}J=C==I.length-1?true:false;A.later(E,this,this._transitionSlice,[I[C],G,J]);E+=H;}this._transitionSlicesFadeLast(E);},_transitionBoxes:function(){this.get("itemIn").one(".fl-slideshow-image-img").setStyle("opacity",0);var D=this.get("boxCols"),H=this.get("boxRows"),L=D*H,I=this._type!="boxesRandom",O=this._renderSlices(H,D,I),E=this.get("duration"),G=0,M=150,N=false,F=0,P=0,C=0,B=-1,K=null,J={duration:E,opacity:1};if(!I){O=this._randomizeSlices(O);M=30;for(;F<O.length;F++){K=A.clone(J);N=F==O.length-1?true:false;A.later(G,this,this._transitionSlice,[O[F],K,N]);G+=M;}}else{while(F<L){for(P=0;P<H;P++){if(P===0){B++;C=B;}if(C>-1&&C<D){F++;K=A.clone(J);if(this._type=="boxesGrow"){K.height=parseFloat(O[P][C].getComputedStyle("height"),10)+"px";K.width=parseFloat(O[P][C].getComputedStyle("width"),10)+"px";O[P][C].setStyle("height","0px");O[P][C].setStyle("width","0px");M=50;}N=F==L-1?true:false;A.later(G,this,this._transitionSlice,[O[P][C],K,N]);}C--;}G+=M;}}this._transitionSlicesFadeLast(G);},_renderSlices:function(F,H,P){var L=this.get("itemIn"),R=parseFloat(L.getComputedStyle("height"),10),G=parseFloat(L.getComputedStyle("width"),10),T=L.one("img"),B=T.get("src"),S=parseFloat(T.getComputedStyle("height"),10),O=parseFloat(T.getComputedStyle("width"),10),D=parseFloat(T.getComputedStyle("left"),10),N=parseFloat(T.getComputedStyle("top"),10),J=0,M=0,E=Math.round(R/F),K=Math.round(G/H),Q=null,I=null,C=[];for(;M<F;M++){if(typeof P!=="undefined"&&P){C[M]=[];}for(J=0;J<H;J++){Q=A.Node.create('<div class="fl-slideshow-transition-slice"></div>');I=A.Node.create('<img src="'+B+'" />');Q.setStyles({left:(K*J)+"px",top:(E*M)+"px",width:J==H-1?(G-(K*J))+"px":K+"px",height:M==F-1?(R-(E*M))+"px":E+"px",opacity:0});I.setStyles({height:S+"px",width:O+"px",top:N-((E+(M*E))-E)+"px",left:D-((K+(J*K))-K)+"px"});Q.append(I);L.append(Q);if(typeof P!=="undefined"&&P){C[M].push(Q);}else{C.push(Q);}}}return C;},_transitionSlicesFadeLast:function(B){var C=this.get("itemOut");if(C&&!C.hasClass("fl-slideshow-image-cropped")){C.transition({duration:B/1000+this.get("duration"),opacity:0});}},_transitionSlice:function(D,B,C){var E=C?A.bind(this._transitionSlicesComplete,this):null;D.transition(B,E);},_transitionSlicesComplete:function(){var B=this.get("itemIn");B.all(".fl-slideshow-transition-slice").remove();B.one(".fl-slideshow-image-img").setStyle("opacity",1);this._transitionComplete();},_randomizeSlices:function(E){var D=E.length,C,B;if(D===0){return;}while(--D){C=Math.floor(Math.random()*(D+1));B=E[D];E[D]=E[C];E[C]=B;}return E;},_transitionKenBurns:function(){var C=this.get("kenBurnsDuration"),D=this.get("duration"),E=this.get("itemIn"),B=this.get("kenBurnsZoom");this._transitionFade();(new A.FL.SlideshowKenBurns({duration:C+D+4,image:E,zoom:B})).run();}},{ATTRS:{itemIn:{value:null},itemOut:{value:null},duration:{value:0.5},easing:{value:"ease-out"},type:{value:"fade"},bars:{value:15},boxCols:{value:8},boxRows:{value:4},kenBurnsDuration:{value:4},kenBurnsZoom:{value:1.2}},TYPES:{fade:"_transitionFade",none:"_transitionNone",slideLeft:"_transitionSlideLeft",slideRight:"_transitionSlideRight",slideUp:"_transitionSlideUp",slideDown:"_transitionSlideDown",blinds:"_transitionBars",bars:"_transitionBars",barsRandom:"_transitionBars",boxes:"_transitionBoxes",boxesRandom:"_transitionBoxes",boxesGrow:"_transitionBoxes",kenBurns:"_transitionKenBurns"},SLIDESHOW_IMAGE_TYPES:["blinds","bars","barsRandom","boxes","boxesRandom","boxesGrow","kenBurns"]});A.namespace("FL").Slideshow=A.Base.create("fl-slideshow",A.FL.SlideshowBase,[],{frame:null,nav:null,imageNavLeft:null,imageNavRight:null,thumbs:null,verticalThumbs:null,caption:null,social:null,_nextImagePreloader:null,_initialNavSettings:null,initializer:function(){var B={loadGroup:"main-preload",crop:this.get("crop"),position:this.get("position"),protect:this.get("protect"),upsize:this.get("upsize")};this._nextImagePreloader=new A.FL.SlideshowImage(B);if("ontouchstart" in window){this._removeNavButton("prev");this._removeNavButton("prevPage");this._removeNavButton("next");this._removeNavButton("nextPage");this._removeNavButton("fullscreen");}if(this._hasNavButton("fullscreen")){if(A.FL.SlideshowFullscreen.OS_SUPPORT){this.plug(A.FL.SlideshowFullscreen);}else{this._removeNavButton("fullscreen");}}},renderUI:function(){A.FL.Slideshow.superclass.renderUI.apply(this,arguments);this._renderFrame();this._renderVerticalThumbs();this._renderNavAndThumbs();this._renderImageNav();this._renderMouseNav();this._renderCaption();this._renderSocial();},bindUI:function(){var F=this.get("boundingBox"),E=this.frame.get("boundingBox"),D=this.get("navOverlay"),C=this.get("navType"),G=this._getNav(),B=this.get("clickAction");A.FL.Slideshow.superclass.bindUI.apply(this,arguments);A.Do.after(this._resizeChildWidgets,this,"resize");this.on("albumLoadStart",this._albumLoadStart,this);this.on("albumLoadComplete",this._albumLoadComplete,this);this.on("imageLoadComplete",this._loadFrame,this);if(this.get("loadingImageAlwaysEnabled")){this.frame.on("transitionInit",A.bind(this._showLoadingImageWithDelay,this));this.frame.on("transitionStart",A.bind(this._hideLoadingImage,this));}if(this.get("overlayHideOnMousemove")){if(G&&D){this.frame.once("transitionComplete",G.slideshowOverlay.hideWithTimer,G.slideshowOverlay);
F.on("mousemove",A.bind(this._toggleNav,this));}if(C=="buttons"||C=="thumbs"||C=="custom"){F.on("mouseenter",A.bind(this._checkOverlaysOnMouseenter,this));F.on("mouseleave",A.bind(this._hideAllOverlays,this));}}F.delegate("click",A.bind(this._overlayCloseClick,this),".fl-slideshow-overlay-close");if(B=="gallery"||B=="url"){E.delegate("click",A.bind(this._frameClick,this),".fl-slideshow-image-img");}},syncUI:function(){var B=this.get("boundingBox");A.FL.Slideshow.superclass.syncUI.apply(this,arguments);B._node.onselectstart=function(){return false;};B._node.unselectable="on";B._node.style.MozUserSelect="none";if(this.get("clickAction")!="none"){this.frame.get("boundingBox").addClass("fl-click-action-enabled");}},unload:function(){this.pause();this.frame.unload();if(this.thumbs!==null){this.thumbs.unload();}},_albumLoadStart:function(){this._showLoadingImage();},_albumLoadComplete:function(){this.frame.once("transitionStart",A.bind(this._hideLoadingImage,this));},_resizeChildWidgets:function(){var D=this.get("boundingBox"),B=this.get("contentBox"),C=this.get("imageNavEnabled");this._renderNavAndThumbs();if(this.get("verticalThumbsOverlay")){this._resizeFrame(B.get("offsetWidth"),D.get("offsetHeight"));this._resizeVerticalThumbs();}else{this._resizeVerticalThumbs();this._resizeFrame(B.get("offsetWidth"),D.get("offsetHeight"));}if(C){this._positionImageNav();}this._positionLoadingImage();},_renderVerticalThumbs:function(){var B=this.get("responsiveThreshold"),E=this.get("boundingBox"),C=E.get("offsetWidth"),D;if(this.get("verticalThumbsEnabled")&&C>B){this.verticalThumbs=new A.FL.SlideshowThumbs(this._getVerticalThumbsConfig());this.add(this.verticalThumbs);this.verticalThumbs.render(E);D=this.verticalThumbs.get("boundingBox");D.addClass("fl-slideshow-vertical-thumbs");D.setStyle(this.get("verticalThumbsPosition"),0);E.append(D);if(this.get("verticalThumbsOverlay")){this.verticalThumbs.plug(A.FL.SlideshowOverlay,{hideDelay:this.get("overlayHideDelay"),hideStyle:"left"});this.frame.get("boundingBox").append(D);this.verticalThumbs.resize();}else{this.verticalThumbs.resize();this._adjustContentForVerticalThumbs();}this._bindVerticalThumbs();}},_getVerticalThumbsConfig:function(){var C=this.getAttrs(),B={columns:C.verticalThumbsColumns,rows:"auto",centerSinglePage:false,horizontalSpacing:C.verticalThumbsHorizontalSpacing,verticalSpacing:C.verticalThumbsVerticalSpacing,spaceEvenly:C.verticalThumbsSpaceEvenly,rightNavEnabled:false,leftNavEnabled:false,topNavEnabled:C.verticalThumbsTopNavEnabled,topNavButtons:C.verticalThumbsTopNavButtons,bottomNavEnabled:C.verticalThumbsBottomNavEnabled,bottomNavButtons:C.verticalThumbsBottomNavButtons,pauseOnClick:C.verticalThumbsPauseOnClick,transition:C.verticalThumbsTransition,transitionDirection:C.verticalThumbsTransitionDirection,transitionEasing:C.verticalThumbsTransitionEasing,touchSupport:true,imageConfig:{crop:C.verticalThumbsImageCrop,width:C.verticalThumbsImageWidth,height:C.verticalThumbsImageHeight}};return B;},_bindVerticalThumbs:function(){var B=this.get("boundingBox"),E=this.get("overlayHideOnMousemove"),D=this.get("verticalThumbsOverlay"),C=this.verticalThumbs;if(C&&E&&D){this.frame.once("transitionComplete",C.slideshowOverlay.hideWithTimer,C.slideshowOverlay);B.on("mousemove",A.bind(this._toggleVerticalThumbs,this));B.on("mouseenter",A.bind(this._toggleVerticalThumbs,this));}},_resizeVerticalThumbs:function(){var G=this.get("verticalThumbsEnabled"),H,I,F,C,D,E,B,J;if(G){H=this.get("verticalThumbsOverlay");I=this.get("responsiveThreshold");F=this.get("boundingBox");C=F.get("offsetWidth");D=this.get("navOverlay");E=this.get("navType");B=this._getNav();if(this.verticalThumbs&&C>I){this.verticalThumbs.get("boundingBox").setStyle("display","block");this.verticalThumbs.resize();if(!H){this._adjustContentForVerticalThumbs();}else{if(B&&D){J=B.get("boundingBox");if(E=="thumbs"){this._adjustOverlayForVerticalThumbs(J,true);this.thumbs.resize();}else{this._adjustOverlayForVerticalThumbs(J);}}}}else{if(!this.verticalThumbs&&C>I){this._renderVerticalThumbs();}else{if(this.verticalThumbs&&C<=I){this.verticalThumbs.get("boundingBox").setStyle("display","none");if(!H){this.get("contentBox").setStyles({left:"auto",position:"relative",right:"auto",width:"auto"});}}}}}},_toggleVerticalThumbs:function(){if(this.verticalThumbs){if(this.verticalThumbs.slideshowOverlay._visible){this.verticalThumbs.slideshowOverlay.hideWithTimer();}else{this.verticalThumbs.slideshowOverlay.show();}}},_adjustContentForVerticalThumbs:function(){var E=this.get("boundingBox"),C=this.verticalThumbs.get("boundingBox"),B=this.get("verticalThumbsPosition"),G=this.get("contentBox"),F=B=="left"?"right":"left",D=E.get("offsetWidth")-C.get("offsetWidth");G.setStyle("position","absolute");G.setStyle(F,0);G.setStyle("width",D);},_adjustOverlayForVerticalThumbs:function(F,C){var H=this.get("verticalThumbsEnabled"),I=this.get("verticalThumbsOverlay"),E=null,D=null,G=typeof C==="undefined"?"":"margin-",B=0;if(this.verticalThumbs&&H&&I){E=this.verticalThumbs.get("boundingBox");B=E.get("offsetWidth");D=this.get("verticalThumbsPosition");if(D=="left"){F.setStyle(G+"left",B+"px");}else{F.setStyle(G+"right",B+"px");}}},_renderFrame:function(){this.frame=new A.FL.SlideshowFrame({imageConfig:{loadGroup:"main",loadPriority:true,crop:this.get("crop"),cropHorizontalsOnly:this.get("cropHorizontalsOnly"),position:this.get("position"),protect:this.get("protect"),upsize:this.get("upsize"),showVideoButton:this.get("navOverlay")},touchSupport:true});this.add(this.frame);this.frame.render(this.get("contentBox"));this.frame.get("boundingBox").addClass("fl-slideshow-main-image");this._setPlayingTimerEvent(this.frame,"transitionComplete");this._loadingImageContainer=this.frame.get("contentBox");},_resizeFrame:function(D,B){var C=this.get("navOverlay"),E=this._getNav();if(E&&!C){B-=parseInt(E.get("boundingBox").getComputedStyle("height"),10);}this.frame.resize(D,B);},_loadFrame:function(G){var E=this.imageInfo.index,D=this.albumInfo.images,C=E+1>=D.length?0:E+1,F=this.frame.get("width"),B=this.frame.get("height");
this.frame.load(G.imageInfo);A.FL.SlideshowImageLoader.removeGroup("main-preload");this._nextImagePreloader.preload(D[C],F,B);},_frameClick:function(){var B=this.get("clickAction"),C=this.get("clickActionUrl");if(B=="url"){window.location.href=C;}else{if(B=="gallery"){window.location.href=this.imageInfo.link;}}},_initMiniNav:function(){var B=[];if(!("ontouchstart" in window)){B.push("prev");}if(this._hasNavButton("thumbs")||this.get("navType")=="thumbs"){B.push("thumbs");}if(this._hasNavButton("caption")){B.push("caption");}if(this._hasNavButton("social")){B.push("social");}if(this._hasNavButton("buy")){B.push("buy");}if(this._hasNavButton("play")){B.push("play");}if(this._hasNavButton("fullscreen")&&!("ontouchstart" in window)){B.push("fullscreen");}if(!("ontouchstart" in window)){B.push("next");}this._initialNavSettings={buttons:this.get("navButtons"),buttonsLeft:this.get("navButtonsLeft"),buttonsRight:this.get("navButtonsRight"),type:this.get("navType")};this._set("navButtons",B);this._set("navButtonsLeft",[]);this._set("navButtonsRight",[]);this._set("navType","buttons");},_renderNavAndThumbs:function(){var C=this.get("navType"),D=false,E,B;if(C=="buttons"||C=="thumbs"){E=this.get("boundingBox").get("offsetWidth");B=this.get("responsiveThreshold");if(E<=B&&this._initialNavSettings===null){this._initMiniNav();D=true;}else{if(E>B&&this._initialNavSettings!==null){this._set("navButtons",this._initialNavSettings.buttons);this._set("navButtonsLeft",this._initialNavSettings.buttonsLeft);this._set("navButtonsRight",this._initialNavSettings.buttonsRight);this._set("navType",this._initialNavSettings.type);this._initialNavSettings=null;D=true;}}if(D||this.nav===null){this._renderNav();}if(D||this.thumbs===null){this._renderThumbs();}else{if(this._thumbsEnabled()){this._resizeThumbs();}}if(D&&this.caption!==null){this._syncCaption();}if(D&&this.social!==null){this._syncSocial();}}},_renderNav:function(){var D=this.frame.get("boundingBox"),E=null,B=this.get("navOverlay"),C=this.get("navPosition");this._destroyNav();if(this.get("navType")=="buttons"){this.nav=new A.FL.SlideshowNav({buttons:this.get("navButtons"),buttonsLeft:this.get("navButtonsLeft"),buttonsRight:this.get("navButtonsRight")});this.add(this.nav);this.nav.render(this.get("contentBox"));E=this.nav.get("boundingBox");if(B){this.nav.plug(A.FL.SlideshowOverlay,{hideDelay:this.get("overlayHideDelay")});E.setStyle("position","absolute");E.setStyle(C,"0px");}if(C=="top"){D.insert(E,"before");}else{D.insert(E,"after");}E.addClass("fl-slideshow-main-nav");}},_destroyNav:function(){if(this.nav!==null){if(this.nav.slideshowOverlay){this.nav.slideshowOverlay.destroy();}this.nav.get("boundingBox").remove();this.remove(this.nav);try{this.nav.destroy(true);}catch(B){}this.nav=null;}},_getNav:function(){var B=this.get("navType");if(B=="buttons"){return this.nav;}else{if(B=="thumbs"){return this.thumbs;}else{return null;}}},_toggleNav:function(){var B=this._getNav();if(B.slideshowOverlay){if(B.slideshowOverlay._visible){B.slideshowOverlay.hideWithTimer();}else{B.slideshowOverlay.show();}}},_renderImageNav:function(){var B;if(this.get("imageNavEnabled")){if("ontouchstart" in window){this._set("imageNavEnabled",false);}else{B=this.get("boundingBox");this.imageNavLeft=new A.FL.SlideshowNav({buttons:["prev"],useFontIcons:false});this.imageNavRight=new A.FL.SlideshowNav({buttons:["next"],useFontIcons:false});this.add(this.imageNavLeft);this.add(this.imageNavRight);this.imageNavLeft.render(this.frame.get("boundingBox"));this.imageNavRight.render(this.frame.get("boundingBox"));this.imageNavLeft.plug(A.FL.SlideshowOverlay,{hideDelay:this.get("overlayHideDelay")});this.imageNavRight.plug(A.FL.SlideshowOverlay,{hideDelay:this.get("overlayHideDelay")});if(this.get("overlayHideOnMousemove")){this.frame.once("transitionComplete",this.imageNavLeft.slideshowOverlay.hideWithTimer,this.imageNavLeft.slideshowOverlay);this.frame.once("transitionComplete",this.imageNavRight.slideshowOverlay.hideWithTimer,this.imageNavRight.slideshowOverlay);B.on("mousemove",A.bind(this._toggleImageNav,this));B.on("mouseenter",A.bind(this._toggleImageNav,this));}this.imageNavLeft.get("boundingBox").addClass("fl-slideshow-image-nav-left");this.imageNavRight.get("boundingBox").addClass("fl-slideshow-image-nav-right");}}},_positionImageNav:function(){var D=this.imageNavLeft.get("boundingBox"),E=this.imageNavRight.get("boundingBox"),B=D.get("offsetHeight"),C=this.frame.get("boundingBox").get("offsetHeight"),G=C/2-B/2,F={top:G+"px",display:"block"};D.setStyles(F);E.setStyles(F);this._adjustOverlayForVerticalThumbs(D);this._adjustOverlayForVerticalThumbs(E);},_toggleImageNav:function(){if(this.imageNavLeft.slideshowOverlay._visible){this.imageNavLeft.slideshowOverlay.hideWithTimer();}else{this.imageNavLeft.slideshowOverlay.show();}if(this.imageNavRight.slideshowOverlay._visible){this.imageNavRight.slideshowOverlay.hideWithTimer();}else{this.imageNavRight.slideshowOverlay.show();}},_renderMouseNav:function(){if(this.get("mouseNavEnabled")&&!("ontouchstart" in window)&&!window.navigator.msPointerEnabled){this.plug(A.FL.SlideshowMouseNav,{trigger:this.frame.get("boundingBox")});}},_thumbsEnabled:function(){var B=this.get("navType");if(B=="thumbs"){return true;}if((B=="buttons"||B=="custom")&&this._hasNavButton("thumbs")){return true;}else{return false;}},_renderThumbs:function(){var E,C,D,B;this._destroyThumbs();if(this._thumbsEnabled()){E=this.frame.get("boundingBox");C=this.get("navOverlay");D=this.get("navPosition");B=this.get("navType");this.thumbs=new A.FL.SlideshowThumbs(this._getThumbsConfig());try{this.add(this.thumbs);}catch(F){}if(B=="buttons"||B=="custom"){this.thumbs.plug(A.FL.SlideshowOverlay,{hideDelay:this.get("overlayHideDelay"),hideStyle:"left",visible:false});}else{if(B=="thumbs"&&C){this.thumbs.plug(A.FL.SlideshowOverlay,{hideDelay:this.get("overlayHideDelay"),hideStyle:"left"});}}this.thumbs.render(this.get("contentBox"));if(D=="top"){E.insert(this.thumbs.get("boundingBox"),"before");
}else{E.insert(this.thumbs.get("boundingBox"),"after");}if(this.get("thumbsHideOnClick")&&B!="thumbs"){this.thumbs.on("imageClick",A.bind(this._hideThumbsOnImageClick,this));}this._syncThumbs();}},_destroyThumbs:function(){if(this.thumbs!==null){if(this.thumbs.slideshowOverlay){this.thumbs.slideshowOverlay.destroy();}this.thumbs.get("boundingBox").remove();this.remove(this.thumbs);try{this.thumbs.destroy(true);}catch(B){}this.thumbs=null;}},_syncThumbs:function(){var D=this.thumbs.get("boundingBox"),E=this.get("navOverlay"),F=this.get("navPosition"),C=this.get("navType"),B="padding"+F.charAt(0).toUpperCase()+F.slice(1),G=0;if(C=="buttons"){G=parseInt(this.nav.get("boundingBox").getComputedStyle("height"),10);D.setStyle("position","absolute");if(E){D.setStyle(B,G+"px");D.setStyle(F,"0px");}else{D.setStyle(F,G+"px");}}if(C=="custom"||(C=="thumbs"&&E)){D.setStyle("position","absolute");D.setStyle(F,"0px");}this.thumbs.resize();},_getThumbsConfig:function(){var E=this.getAttrs(),B=this.get("navType"),D={crop:E.thumbsImageCrop,width:E.thumbsImageWidth,height:E.thumbsImageHeight},C={columns:"auto",rows:1,horizontalSpacing:E.thumbsHorizontalSpacing,verticalSpacing:E.thumbsVerticalSpacing,spaceEvenly:E.thumbsSpaceEvenly,centerSinglePage:E.thumbsCenterSinglePage,pauseOnClick:E.thumbsPauseOnClick,transition:E.thumbsTransition,transitionDirection:E.thumbsTransitionDirection,transitionEasing:E.thumbsTransitionEasing,leftNavButtons:E.navButtonsLeft,rightNavButtons:E.navButtonsRight,imageConfig:D,touchSupport:true};if(B=="buttons"||B=="custom"){if("ontouchstart" in window){C.leftNavEnabled=false;C.rightNavEnabled=false;}else{C.centerSinglePage=false;C.leftNavButtons=["prevPage"];C.rightNavButtons=["nextPage"];}}return C;},_resizeThumbs:function(){if(this.thumbs){this.thumbs.resize();}},_toggleThumbs:function(){this._toggleOverlay(this.thumbs.slideshowOverlay);},_hideThumbsOnImageClick:function(){if(this.thumbs.slideshowOverlay){this.thumbs.slideshowOverlay._focus=false;this.thumbs.slideshowOverlay.enable();this.thumbs.slideshowOverlay.hide();if(this.nav&&this.nav.slideshowOverlay){this.nav.slideshowOverlay.enable();}}},_renderCaption:function(){if(this._hasNavButton("caption")){this.caption=new A.FL.SlideshowCaption({lessLinkText:this.get("captionLessLinkText"),moreLinkText:this.get("captionMoreLinkText"),textLength:this.get("captionTextLength"),stripTags:this.get("captionStripTags")});this.add(this.caption);this.caption.plug(A.FL.SlideshowOverlay,{hideDelay:this.get("overlayHideDelay"),visible:false,closeButton:true});this._syncCaption();}},_syncCaption:function(){var G=this.caption.get("boundingBox"),C=this.get("navOverlay"),D=this.get("navPosition"),E=this._getNav(),B="padding"+D.charAt(0).toUpperCase()+D.slice(1),F=0;G.setStyle("position","absolute");if(E){F=parseInt(E.get("boundingBox").getComputedStyle("height"),10);}if(E&&C){G.setStyle(B,F+"px");G.setStyle(D,"0px");}else{G.setStyle(D,F+"px");}},_toggleCaption:function(){this._toggleOverlay(this.caption.slideshowOverlay);},_renderSocial:function(){if(this._hasNavButton("social")){this.social=new A.FL.SlideshowSocial();this.add(this.social);this.social.plug(A.FL.SlideshowOverlay,{hideDelay:this.get("overlayHideDelay"),visible:false,closeButton:true});this._syncSocial();}},_syncSocial:function(){var D=this.social.get("boundingBox"),C=this.get("navOverlay"),E=this.get("navPosition"),F=this._getNav(),B="padding"+E.charAt(0).toUpperCase()+E.slice(1),G=0;D.setStyle("position","absolute");if(F){G=parseInt(F.get("boundingBox").getComputedStyle("height"),10);}if(F&&C){D.setStyle(B,G+"px");D.setStyle(E,"0px");}else{D.setStyle(E,G+"px");}},_toggleSocial:function(){this._toggleOverlay(this.social.slideshowOverlay);},_toggleOverlay:function(C){var B=this.get("navType"),D=this._getNav();if(C._visible){if(D&&D.slideshowOverlay){D.slideshowOverlay.enable();}C.enable();C.hide();}else{if(D&&D.slideshowOverlay){D.slideshowOverlay.disable();}C.show();C.disable();}if(this.thumbs&&B!="thumbs"&&this.thumbs.slideshowOverlay!==C){this.thumbs.slideshowOverlay.enable();this.thumbs.slideshowOverlay.hide();}if(this.caption&&this.caption.slideshowOverlay!==C){this.caption.slideshowOverlay.enable();this.caption.slideshowOverlay.hide();}if(this.social&&this.social.slideshowOverlay!==C){this.social.slideshowOverlay.enable();this.social.slideshowOverlay.hide();}},_overlayCloseClick:function(){if(this.nav&&this.nav.slideshowOverlay){this.nav.slideshowOverlay.enable();}if(this.thumbs&&this.thumbs.slideshowOverlay){this.thumbs.slideshowOverlay.enable();}if(this.caption){this.caption.slideshowOverlay.enable();}if(this.social){this.social.slideshowOverlay.enable();}if(this.imageNavLeft){this.imageNavLeft.slideshowOverlay.enable();this.imageNavRight.slideshowOverlay.enable();}},_hideAllOverlays:function(){if(this.nav&&this.nav.slideshowOverlay&&this.nav.slideshowOverlay._visible){this.nav.slideshowOverlay.enable();this.nav.slideshowOverlay.hideWithTimer();}if(this.thumbs&&this.thumbs.slideshowOverlay&&this.thumbs.slideshowOverlay._visible){this.thumbs.slideshowOverlay.enable();this.thumbs.slideshowOverlay.hideWithTimer();}if(this.caption&&this.caption.slideshowOverlay._visible){this.caption.slideshowOverlay.enable();this.caption.slideshowOverlay.hideWithTimer();}if(this.social&&this.social.slideshowOverlay._visible){this.social.slideshowOverlay.enable();this.social.slideshowOverlay.hideWithTimer();}if(this.imageNavLeft){this.imageNavLeft.slideshowOverlay.enable();this.imageNavLeft.slideshowOverlay.hideWithTimer();this.imageNavRight.slideshowOverlay.enable();this.imageNavRight.slideshowOverlay.hideWithTimer();}},_checkOverlaysOnMouseenter:function(){var B=this.get("navType"),D=this.get("navOverlay"),E=this._getNav(),C=false;if(this.thumbs&&B!="thumbs"&&this.thumbs.slideshowOverlay._visible){C=true;this.thumbs.slideshowOverlay.disable();}else{if(this.caption&&this.caption.slideshowOverlay._visible){C=true;this.caption.slideshowOverlay.disable();}else{if(this.social&&this.social.slideshowOverlay._visible){C=true;
this.social.slideshowOverlay.disable();}}}if(E&&C&&D){E.slideshowOverlay.disable();}},_hasNavButton:function(C){var B=this.get("navType");if(B=="buttons"||B=="thumbs"||B=="custom"){if(A.Array.indexOf(this.get("navButtons"),C)>-1){return true;}else{if(A.Array.indexOf(this.get("navButtonsLeft"),C)>-1){return true;}else{if(A.Array.indexOf(this.get("navButtonsRight"),C)>-1){return true;}else{return false;}}}}else{return false;}},_removeNavButton:function(D){var G=this.get("navButtons"),B=this.get("navButtonsLeft"),F=this.get("navButtonsRight"),C=this.get("verticalThumbsTopNavButtons"),E=this.get("verticalThumbsBottomNavButtons");if(A.Array.indexOf(G,D)>-1){G.splice(A.Array.indexOf(G,D),1);}if(A.Array.indexOf(B,D)>-1){B.splice(A.Array.indexOf(B,D),1);}if(A.Array.indexOf(F,D)>-1){F.splice(A.Array.indexOf(F,D),1);}if(A.Array.indexOf(C,D)>-1){C.splice(A.Array.indexOf(C,D),1);}if(A.Array.indexOf(E,D)>-1){E.splice(A.Array.indexOf(E,D),1);}this._set("navButtons",G);this._set("navButtonsLeft",B);this._set("navButtonsRight",F);this._set("verticalThumbsTopNavButtons",C);this._set("verticalThumbsBottomNavButtons",E);}},{CSS_PREFIX:"fl-slideshow",ATTRS:{clickAction:{value:"none"},clickActionUrl:{value:""},crop:{value:false},cropHorizontalsOnly:{value:false},loadingImageAlwaysEnabled:{value:true},position:{value:"center center"},protect:{value:true},upsize:{value:true},transition:{value:"fade"},transitionDuration:{value:1},transitionEasing:{value:"ease-out"},kenBurnsZoom:{value:1.2},navType:{value:"none"},navPosition:{value:"bottom"},navOverlay:{value:false},navButtons:{value:[]},navButtonsLeft:{value:[]},navButtonsRight:{value:[]},overlayHideOnMousemove:{value:true},overlayHideDelay:{value:3000},imageNavEnabled:{value:false},mouseNavEnabled:{value:false},thumbsHideOnClick:{value:true},thumbsHorizontalSpacing:{value:15},thumbsVerticalSpacing:{value:15},thumbsSpaceEvenly:{value:true},thumbsCenterSinglePage:{value:true},thumbsPauseOnClick:{value:false},thumbsTransition:{value:"slideHorizontal"},thumbsTransitionDuration:{value:0.8},thumbsTransitionEasing:{value:"ease-out"},thumbsImageCrop:{value:true},thumbsImageWidth:{value:50},thumbsImageHeight:{value:50},captionLessLinkText:{value:"Read Less"},captionMoreLinkText:{value:"Read More"},captionTextLength:{value:200},captionStripTags:{value:false},verticalThumbsEnabled:{value:false},verticalThumbsPosition:{value:"left"},verticalThumbsOverlay:{value:false},verticalThumbsColumns:{value:1},verticalThumbsTopNavEnabled:{value:false},verticalThumbsTopNavButtons:{value:["prevPage","nextPage"]},verticalThumbsBottomNavEnabled:{value:true},verticalThumbsBottomNavButtons:{value:["prevPage","nextPage"]},verticalThumbsHorizontalSpacing:{value:15},verticalThumbsVerticalSpacing:{value:15},verticalThumbsSpaceEvenly:{value:false},verticalThumbsPauseOnClick:{value:false},verticalThumbsImageCrop:{value:true},verticalThumbsImageWidth:{value:75},verticalThumbsImageHeight:{value:75},verticalThumbsTransition:{value:"slideVertical"},verticalThumbsTransitionDuration:{value:0.8},verticalThumbsTransitionEasing:{value:"ease-out"},googlePlusButtonEnabled:{value:true},likeButtonEnabled:{value:true},pinterestButtonEnabled:{value:true},tweetButtonEnabled:{value:true}}});},"2.0.0",{requires:["anim","event-mouseenter","plugin","transition","fl-event-move","fl-slideshow-css","fl-slideshow-base","fl-utils","sm-fonticon"]});YUI.add("fl-slideshow-album-loader",function(A){A.namespace("FL").SlideshowAlbumLoader=A.Base.create("fl-slideshow-album-loader",A.Base,[],{_source:null,load:function(B){this._source=B;this.fire("start");this[A.FL.SlideshowAlbumLoader.TYPES[B.type]].call(this);},_loadComplete:function(B){B=this._randomize(B);this.fire("complete",B);},_randomize:function(C){var B;if(this.get("randomize")){C.albumInfo.images.sort(function(){return 0.5-Math.random();});for(B=0;B<C.albumInfo.images.length;B++){C.albumInfo.images[B].index=B;}}return C;},_loadSmugMug:function(){var B=new A.FL.SmugMugAPI();B.on("complete",this._loadSmugMugSuccess,this);B.addParam("method","smugmug.images.get");B.addParam("AlbumID",this._source.id);B.addParam("AlbumKey",this._source.key);B.addParam("Extras","Caption,Format,FileName");if(this._source.password){B.addParam("Password",this._source.password);}if(this._source.sp){B.addParam("SitePassword",this._source.sp);}B.request();},_loadSmugMugSuccess:function(H){var J=H.Album.Images,E={},I=typeof this._source.proxy!=="undefined"?this._source.proxy:"",C="",B="",D="",K="",G=0,L=null,F=null;E.index=this._source.index;E.id=H.Album.id;E.key=H.Album.Key;E.link=H.Album.URL;E.title=this._source.title?this._source.title:"";E.images=[];C=E.link.replace("http://","").split("/").shift();C="http://"+C+"/buy/"+H.Album.id+"_"+H.Album.Key+"/";for(G=0;G<J.length;G++){B=I+H.Album.URL+"/"+J[G].id+"_"+J[G].Key;K=J[G].Format.toLowerCase();D=K=="mp4"?".jpg":"."+K;E.images[G]={};E.images[G].index=G;E.images[G].sourceType="smugmug";E.images[G].albumId=H.Album.id;E.images[G].albumKey=H.Album.Key;E.images[G].id=J[G].id;E.images[G].key=J[G].Key;E.images[G].filename=J[G].FileName;E.images[G].format=K;E.images[G].caption=J[G].Caption||"";E.images[G].link=H.Album.URL+"#"+J[G].id+"_"+J[G].Key;E.images[G].tinyURL=B+"-Ti"+D;E.images[G].thumbURL=B+"-Th"+D;E.images[G].smallURL=B+"-S"+D;E.images[G].mediumURL=B+"-M"+D;E.images[G].largeURL=B+"-L"+D;E.images[G].xlargeURL=B+"-XL"+D;E.images[G].x2largeURL=B+"-X2"+D;E.images[G].x3largeURL=B+"-X3"+D;E.images[G].buyURL=C+J[G].id+"_"+J[G].Key;E.images[G].iframe="";if(E.images[G].caption.indexOf("iframe")){L=A.Node.create("<div>"+E.images[G].caption+"</div>");F=L.one("iframe");if(F){E.images[G].iframe=F.getAttribute("src");E.images[G].caption=E.images[G].caption.replace(/<iframe.*>.*<\/iframe>/gi,"");}}}this._loadComplete({"albumInfo":E});},_loadUrls:function(){var B={},C=0;B.index=this._source.index;B.title=this._source.title?this._source.title:"";B.images=[];for(;C<this._source.urls.length;C++){B.images[C]={};B.images[C].index=C;B.images[C].sourceType="urls";B.images[C].filename=this._source.urls[C].largeURL.split("/").pop();B.images[C].format="";B.images[C].caption=this._source.urls[C].caption||"";B.images[C].link=this._source.urls[C].largeURL;B.images[C].thumbURL=this._source.urls[C].thumbURL||this._source.urls[C].largeURL;B.images[C].smallURL=this._source.urls[C].smallURL||this._source.urls[C].largeURL;B.images[C].mediumURL=this._source.urls[C].mediumURL||this._source.urls[C].largeURL;B.images[C].largeURL=this._source.urls[C].largeURL;B.images[C].xlargeURL=this._source.urls[C].xlargeURL||this._source.urls[C].largeURL;B.images[C].x2largeURL=this._source.urls[C].x2largeURL||this._source.urls[C].largeURL;B.images[C].x3largeURL=this._source.urls[C].x3largeURL||this._source.urls[C].largeURL;B.images[C].buyURL=this._source.urls[C].buyURL||"";B.images[C].iframe=this._source.urls[C].iframe||"";}this._loadComplete({"albumInfo":B});}},{ATTRS:{randomize:{value:false}},TYPES:{"smugmug":"_loadSmugMug","flickr":"_loadFlickr","picasa":"_loadPicasa","urls":"_loadUrls","html":"_loadHtml"}});},"2.0.0",{requires:["base","fl-smugmug-api"]});YUI.add("fl-slideshow-base",function(A){A.namespace("FL").SlideshowBase=A.Base.create("fl-slideshow-base",A.Widget,[A.WidgetParent],{_albumLoader:null,albums:[],albumInfo:null,albumIndex:null,imageInfo:null,imageIndex:null,lastImageIndex:null,_resizeTimer:null,_playing:false,_playingTimer:null,_playingTimerEvent:null,_loadingImage:null,_loadingImageWrap:null,_loadingImageVisible:false,_loadingImageTimer:null,_loadingImageContainer:null,_initialHeight:null,_initialWidth:null,initializer:function(){this._albumLoader=new A.FL.SlideshowAlbumLoader({randomize:this.get("randomize")});},renderUI:function(){this._renderLoadingImage();},bindUI:function(){this._albumLoader.on("complete",this._loadAlbumComplete,this);A.one(window).on("fl-slideshow-base|resize",this._delayResize,this);A.one(window).on("fl-slideshow-base|orientationchange",this._delayResize,this);A.Node.one("body").on("keydown",A.bind(this._onKey,this));},syncUI:function(){this.get("boundingBox").addClass("fl-slideshow-"+this.get("color"));this.resize();if(this.get("loadOnRender")){this.loadAlbum(this.get("defaultAlbum"),this.get("defaultImage"));}},addAlbum:function(D){var C=this.get("source"),B=C.length;C[B]=D;C[B].index=B;this.set("source",C);},loadAlbum:function(C,B){var E=this.get("source"),D=typeof B=="undefined"?0:B;this.imageIndex=null;this.lastImageIndex=null;this.fire("albumLoadStart");this.once("albumLoadComplete",A.bind(this.loadImage,this,D));if(E[C]&&E[C].type=="album-data"){this.albums[C]=E[C].data;this._loadAlbumComplete({albumInfo:this.albums[C]});}else{if(E[C]&&this.albums[C]){this._loadAlbumComplete({albumInfo:this.albums[C]});}else{this._albumLoader.load(E[C]||E[0]);}}},_loadAlbumComplete:function(B){this.albums[B.albumInfo.index]=B.albumInfo;this.albumInfo=B.albumInfo;this.albumIndex=B.albumInfo.index;this.fire("albumLoadComplete");if(this.get("autoPlay")){this._playingTimerStart();this.fire("played");this._playing=true;}},loadImage:function(B){if(this._playing){this._playingTimerStart();}B=B<0?this.albumInfo.images.length-1:B;B=B>=this.albumInfo.images.length?0:B;this.lastImageIndex=this.imageIndex;this.imageIndex=B;this.imageInfo=this.albumInfo.images[B];this.fire("imageLoadComplete",{"imageInfo":this.imageInfo});},prevImage:function(){if(this.get("pauseOnNextOrPrev")){this.pause();}this.loadImage(this.imageIndex-1);this.fire("prevImage");},nextImage:function(){if(this.get("pauseOnNextOrPrev")){this.pause();}this.loadImage(this.imageIndex+1);this.fire("nextImage");},_onKey:function(B){switch(B.keyCode){case 37:this.prevImage();break;case 39:this.nextImage();break;}},resize:function(){var E=this.get("stretchy"),D=this.get("stretchyType"),C=parseInt(A.one("body").get("winWidth"),10),B=this.get("responsiveThreshold");if(C>B&&E&&D=="window"){this._stretchyWindowResize();}else{if((C<=B)||(E&&D=="ratio")){this._stretchyRatioResize();}else{this._standardResize();}}this.fire("resize");},_standardResize:function(){var I=this.get("stretchy"),G=this.get("stretchyType"),H=this.get("boundingBox"),F=H.get("parentNode"),C=parseInt(F.getComputedStyle("height"),10),E=parseInt(F.getComputedStyle("width"),10),B=this.get("height"),D=this.get("width");if(H.hasClass("fl-fullscreen-active")){this._stretchyWindowResize();return;}else{if(I&&G=="contain"){H.setStyle("height",C+"px");H.setStyle("width",E+"px");}else{if(!A.Lang.isNumber(B)){this._stretchyRatioResize();return;}else{H.setStyle("height",B+"px");if(D){H.setStyle("width",D+"px");}else{H.setStyle("width",E+"px");}}}}},_stretchyWindowResize:function(){var G=this.get("boundingBox"),E=this.get("stretchyVerticalSpace"),D=parseInt(G.getStyle("paddingTop"),10),F=parseInt(G.getStyle("paddingBottom"),10),B=parseInt(A.one("body").get("winHeight"),10),C="";if(G.hasClass("fl-fullscreen-active")){E=0;C=parseInt(A.one("body").get("winWidth"),10)+"px";}B=(B-D-F-E)+"px";G.setStyle("height",B);G.setStyle("width",C);},_stretchyRatioResize:function(){var G=this.get("boundingBox"),J=G.get("parentNode"),H=0,F=this.get("stretchyRatio"),L=parseInt(G.getStyle("paddingTop"),10),C=parseInt(G.getStyle("paddingBottom"),10),I=parseInt(J.getComputedStyle("width"),10),E=parseInt(A.one("body").get("winHeight"),10),D=parseInt(A.one("body").get("winWidth"),10),K=I*F,B="";if(G.hasClass("fl-fullscreen-active")){K=E;B=D;}K=(K-L-C-H)+"px";G.setStyle("height",K);G.setStyle("width",B);},_delayResize:function(){if(this._resizeTimer){this._resizeTimer.cancel();}this._resizeTimer=A.later(300,this,this.resize);},play:function(){this._playingTimer=A.later(this.get("speed"),this,this._playingTimerComplete);this.fire("played");this._playing=true;},pause:function(){this._playingTimerCancel();this.fire("paused");this._playing=false;},_setPlayingTimerEvent:function(C,B){this._playingTimerEvent={"obj":C,"e":B};},_playingTimerStart:function(B){this._playingTimerCancel();if(!B&&this._playingTimerEvent!==null){this._playingTimerEvent.obj.once("fl-slideshow-base|"+this._playingTimerEvent.e,A.bind(this._playingTimerStart,this));}else{this._playingTimer=A.later(this.get("speed"),this,this._playingTimerComplete);}},_playingTimerComplete:function(){this.loadImage(this.imageIndex+1);this.fire("playingTimerComplete");},_playingTimerCancel:function(){if(this._playingTimer){this._playingTimer.cancel();}if(this._playingTimerEvent){this._playingTimerEvent.obj.detach("fl-slideshow-base|"+this._playingTimerEvent.e);}},_renderLoadingImage:function(){var C={lines:11,length:6,width:2,radius:7,color:"",speed:1,trail:60,shadow:false},B=A.merge(C,this.get("loadingImageSettings"));if(this.get("loadingImageEnabled")){if(B.color===""){B.color=this._colorToHex(A.one("body").getStyle("color"));}this._loadingImage=new A.FL.Spinner(B);this._loadingImageWrap=A.Node.create('<div class="fl-loading-image"></div>');this._loadingImageWrap.setStyles({position:"absolute","z-index":"1000"});}},_showLoadingImage:function(){if(this._loadingImage&&!this._loadingImageVisible){this._loadingImageVisible=true;this._loadingImage.spin();this._loadingImageWrap.insert(this._loadingImage.el);
if(this._loadingImageContainer!==null){this._loadingImageContainer.insert(this._loadingImageWrap);}else{this.get("contentBox").insert(this._loadingImageWrap);}this._positionLoadingImage();}},_showLoadingImageWithDelay:function(){if(this._loadingImage){this._loadingImageTimer=A.later(1000,this,this._showLoadingImage);}},_hideLoadingImage:function(){if(this._loadingImageTimer){this._loadingImageTimer.cancel();this._loadingImageTimer=null;}if(this._loadingImage&&this._loadingImageVisible){this._loadingImageVisible=false;this._loadingImage.stop();this._loadingImageWrap.remove();}},_positionLoadingImage:function(){if(this._loadingImage&&this._loadingImageVisible){var F=this._loadingImageWrap,B=parseInt(F.getComputedStyle("height"),10),G=parseInt(F.getComputedStyle("width"),10),E=F.get("parentNode"),C=parseInt(E.getComputedStyle("height"),10),D=parseInt(E.getComputedStyle("width"),10),I=(D-G)/2,H=(C-B)/2;F.setStyles({left:I+"px",top:H+"px"});A.one(this._loadingImage.el).setStyles({left:"50%",top:"50%"});}},_colorToHex:function(C){var F,G,E,B,D;if(C.substr(0,1)==="#"){return C;}F=/(.*?)rgb\((\d+), (\d+), (\d+)\)/.exec(C);if(null===F){return"#000";}G=parseInt(F[2],10);E=parseInt(F[3],10);B=parseInt(F[4],10);D=B|(E<<8)|(G<<16);D=D.toString(16);if(D==="0"){D="000";}return F[1]+"#"+D;}},{CSS_PREFIX:"fl-slideshow-base",ATTRS:{color:{value:"dark",writeOnce:true},source:{value:[],setter:function(C){if(C.constructor==Object){C=[C];}for(var B=0;B<C.length;B++){C[B].index=B;}return C;}},defaultAlbum:{value:0},defaultImage:{value:0},loadOnRender:{value:true},autoPlay:{value:true},pauseOnNextOrPrev:{value:true},randomize:{value:false},speed:{value:4000},responsiveThreshold:{value:600},stretchy:{value:false},stretchyType:{value:"ratio"},stretchyVerticalSpace:{value:0},stretchyRatio:{value:0.7},loadingImageEnabled:{value:true},loadingImageSettings:{value:{}}}});},"2.0.0",{requires:["node","base","widget","widget-parent","widget-child","fl-slideshow-album-loader","fl-spinner"]});YUI.add("fl-smugmug-api",function(A){A.namespace("FL").SmugMugAPI=A.Base.create("fl-smugmug-api",A.Base,[],{_sessionID:null,_requestURL:null,initializer:function(){this._resetRequestURL();},addParam:function(B,C){this._requestURL=this._requestURL+"&"+B+"="+C;},loginAnon:function(){this.addParam("method","smugmug.login.anonymously");this.once("complete",this._loginAnonComplete);this.request();},_loginAnonComplete:function(B){if(B.Login){this._sessionID=B.Login.Session.id;}},request:function(){this.addParam("Callback","{callback}");A.jsonp(this._requestURL,{on:{success:this._requestComplete,timeout:function(){}},context:this,timeout:60000,args:[]});},_requestComplete:function(B){this._resetRequestURL();this.fire("complete",B);},_resetRequestURL:function(){this._requestURL=this.get("apiURL")+"?APIKey="+this.get("apiKey");if(this._sessionID){this.addParam("SessionID",this._sessionID);}}},{ATTRS:{apiURL:{value:"https://api.smugmug.com/services/api/json/1.3.0/"},apiKey:{value:"7w6kuU5Ee6KSgRRExf2KLgppdkez9JD2"}}});},"2.0.0",{requires:["base","jsonp"]});YUI.add("fl-spinner",function(A){(function(e,E,L){var B="width",Q="length",g="radius",Z="lines",S="trail",V="color",q="opacity",i="speed",a="shadow",k="style",D="height",F="left",G="top",H="px",T="childNodes",p="firstChild",I="parentNode",d="position",J="relative",b="absolute",u="animation",W="transform",N="Origin",f="Timeout",P="coord",m="#000",X=k+"Sheets",M="webkit0Moz0ms0O".split(0),t={},o;function s(w,y){var v=~~((w[Q]-1)/2);for(var x=1;x<=v;x++){y(w[x*2-1],w[x*2]);}}function n(v){var w=E.createElement(v||"div");s(arguments,function(y,x){w[y]=x;});return w;}function c(v,x,w){if(w&&!w[I]){c(v,w);}v.insertBefore(x,w||null);return v;}c(E.getElementsByTagName("head")[0],n(k));var O=E[X][E[X][Q]-1];function C(AA,v){var x=[q,v,~~(AA*100)].join("-"),w="{"+q+":"+AA+"}",y;if(!t[x]){for(y=0;y<M[Q];y++){try{O.insertRule("@"+(M[y]&&"-"+M[y].toLowerCase()+"-"||"")+"keyframes "+x+"{0%{"+q+":1}"+v+"%"+w+"to"+w+"}",O.cssRules[Q]);}catch(z){}}t[x]=1;}return x;}function R(y,z){var x=y[k],v,w;if(x[z]!==L){return z;}z=z.charAt(0).toUpperCase()+z.slice(1);for(w=0;w<M[Q];w++){v=M[w]+z;if(x[v]!==L){return v;}}}function h(v){s(arguments,function(x,w){v[k][R(v,x)||x]=w;});return v;}function Y(v){s(arguments,function(x,w){if(v[x]===L){v[x]=w;}});return v;}var U=function U(v){this.opts=Y(v||{},Z,12,S,100,Q,7,B,5,g,10,V,m,q,1/4,i,1);},K=U.prototype={spin:function(AB){var AD=this,w=AD.el=AD[Z](AD.opts);if(AB){c(AB,h(w,F,~~(AB.offsetWidth/2)+H,G,~~(AB.offsetHeight/2)+H),AB[p]);}if(!o){var v=AD.opts,y=0,z=20/v[i],AA=(1-v[q])/(z*v[S]/100),AC=z/v[Z];(function x(){y++;for(var AE=v[Z];AE;AE--){var AF=Math.max(1-(y+AE*AC)%z*AA,v[q]);AD[q](w,v[Z]-AE,AF,v);}AD[f]=AD.el&&e["set"+f](x,50);})();}return AD;},stop:function(){var v=this,w=v.el;e["clear"+f](v[f]);if(w&&w[I]){w[I].removeChild(w);}v.el=L;return v;}};K[Z]=function(AA){var y=h(n(),d,J),x=C(AA[q],AA[S]),w=0,v;function z(AB,AC){return h(n(),d,b,B,(AA[Q]+AA[B])+H,D,AA[B]+H,"background",AB,"boxShadow",AC,W+N,F,W,"rotate("+~~(360/AA[Z]*w)+"deg) translate("+AA[g]+H+",0)","borderRadius","100em");}for(;w<AA[Z];w++){v=h(n(),d,b,G,1+~(AA[B]/2)+H,W,"translate3d(0,0,0)",u,x+" "+1/AA[i]+"s linear infinite "+(1/AA[Z]/AA[i]*w-1/AA[i])+"s");if(AA[a]){c(v,h(z(m,"0 0 4px "+m),G,2+H));}c(y,c(v,z(AA[V],"0 0 1px rgba(0,0,0,.1)")));}return y;};K[q]=function(w,v,x){w[T][v][k][q]=x;};var r="behavior",l="url(#default#VML)",j="group0roundrect0fill0stroke".split(0);(function(){var w=h(n(j[0]),r,l),v;if(!R(w,W)&&w.adj){for(v=0;v<j[Q];v++){O.addRule(j[v],r+":"+l);}K[Z]=function(){var AE=this.opts,AC=AE[Q]+AE[B],AA=2*AC;function x(){return h(n(j[0],P+"size",AA+" "+AA,P+N,-AC+" "+-AC),B,AA,D,AA);}var AB=x(),AD=~(AE[Q]+AE[g]+AE[B])+H,z;function y(AG,AF,AH){c(AB,c(h(x(),"rotation",360/AE[Z]*AG+"deg",F,~~AF),c(h(n(j[1],"arcsize",1),B,AC,D,AE[B],F,AE[g],G,-AE[B]/2,"filter",AH),n(j[2],V,AE[V],q,AE[q]),n(j[3],q,0))));}if(AE[a]){for(z=1;z<=AE[Z];z++){y(z,-2,"progid:DXImage"+W+".Microsoft.Blur(pixel"+g+"=2,make"+a+"=1,"+a+q+"=.3)");}}for(z=1;z<=AE[Z];z++){y(z);}return c(h(n(),"margin",AD+" 0 0 "+AD,d,J),AB);};K[q]=function(y,x,AA,z){z=z[a]&&z[Z]||0;y[p][T][x+z][p][p][q]=AA;};}else{o=R(w,u);}})();A.namespace("FL").Spinner=U;})(window,document);},"2.0.0");YUI.add("fl-utils",function(A){A.namespace("FL").Utils={cssSupport:function(F){var B=document.body||document.documentElement,E=B.style,C=["Moz","Webkit","Khtml","O","ms","Icab"],D=0;if(F=="transform"&&A.UA.gecko&&A.UA.gecko<4){return false;}if(F=="transform"&&A.UA.opera>0){return false;}if(F=="transform"&&A.UA.ie>0&&A.UA.ie<10){return false;}if(F=="transform"&&navigator.userAgent.match(/Trident/)){return false;}if(typeof E=="undefined"){return false;}if(typeof E[F]=="string"){return true;}F=F.charAt(0).toUpperCase()+F.substr(1);for(;D<C.length;D++){if(typeof E[C[D]+F]=="string"){return true;}}}};},"2.0.0");