<?php
/**
 * artist functions and definitions
 *
 * @package artist
 */
/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
}
define('ARTIST_PATH', get_template_directory_uri() ); 
define('ARTIST_PATH_SERVER_PATH', get_template_directory() );
define('AJAX_URL', admin_url('admin-ajax.php') );

if ( ! function_exists( 'artist_setup' ) ) :
	function artist_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on adelia, use a find and replace
		 * to change 'adelia' to the name of your theme in all the template files
		 */
		load_theme_textdomain( 'artist', get_template_directory() . '/admin/languages' ); 
		load_theme_textdomain( 'artist_framework', get_template_directory() . '/admin/redux-framework/ReduxCore/languages' );
		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );
		
		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'artist_Main_Menu'=>__('Artist Main Menu','artist'),
		) );
		
		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
		) );
		
		/*
		 * Enable support for Post Formats.
		 * See http://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array(
			'aside', 'image', 'video', 'quote', 'link', 'gallery', 'audio'
		) );
		
		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'adelia_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );
		
		if ( function_exists( 'add_theme_support' )){	
			add_theme_support('post-thumbnails');
		}
		
		/*if ( function_exists( 'add_theme_support' ))
			add_theme_support('post-thumbnails',array('post','page','services','portfolio','testimonial'));*/ 
		
		add_theme_support( 'woocommerce' );
		
		if ( function_exists( 'add_image_size' ) ) {
			add_image_size('full-size',9999,9999,true);  
			add_image_size('artist-common-size',1170,497, true);
			add_image_size('artist-blowidget-size',183,183, true); 
			add_image_size( 'small-thumb-services-icon',50,50, true );
		}

	}
endif; 
add_action( 'after_setup_theme', 'artist_setup' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';
/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';
/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';
/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';


/*=============== Register sidebars =================*/
if(!function_exists('artist_widgets_init')){
	function artist_widgets_init()
	{
		register_sidebar(array(
			'name' => 'Primary Sidebar',
			'id'   => 'primary-sidebar',
			'description'   => 'These are widgets for primary sidebar.',
			'before_widget' => '<div class="span12 artist_sidebar_widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<h1 class="lined">',
			'after_title'   => '</h1>'   
		));	
		register_sidebar(array(
			'name' => 'Footer Column1',
			'id' => 'artistfooter-1',
			'description' => 'Widgets in this area will be shown in the footer column 1.',
			'before_widget' => '<div class="span12 artist_sidebar_widget">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="lined">',
			'after_title' => '</h1>',
		));
		register_sidebar(array(
			'name' => 'Footer Column2',
			'id' => 'artistfooter-2',
			'description' => 'Widgets in this area will be shown in the top footer column 2.',
			'before_widget' => '<div class="span12 text-center artist_sidebar_widget">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="lined">',
			'after_title' => '</h1>',
		));
		register_sidebar(array(
			'name' => 'Footer Column3',
			'id' => 'artistfooter-3',
			'description' => 'Widgets in this area will be shown in the top footer column 3.',
			'before_widget' => '<div class="span12 text-center artist_sidebar_widget">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="lined">',
			'after_title' => '</h1>',
		));
		register_sidebar(array(
			'name' => 'Woocommerce Sidebar',
			'id' => 'artist_woo_sidebar',
			'description' => 'Widgets in this area will be shown related woocommerce widgets',
			'before_widget' => '<div class="span12 artist_sidebar_widget">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="lined">',
			'after_title' => '</h1>',
		));
	}
}
add_action( 'widgets_init','artist_widgets_init' );

/*
 * Load redux-framework
 */
if (file_exists(dirname(__FILE__).'/admin/framework.php')) {
    require_once( dirname(__FILE__).'/admin/framework.php' );
}
if (file_exists(dirname(__FILE__).'/admin/artist-config.php')) {
    require_once( dirname(__FILE__).'/admin/artist-config.php' );
}

/*******=============== Required File ===============*******/
if(is_admin()){
	require_once ARTIST_PATH_SERVER_PATH . "/theme_plugin/plugin-activate-config.php";
}
require_once ARTIST_PATH_SERVER_PATH . "/aq_resizer.php";
require_once ARTIST_PATH_SERVER_PATH . '/include/artist-function.php';
require_once ARTIST_PATH_SERVER_PATH . '/include/artist-shortcode.php';
require_once ARTIST_PATH_SERVER_PATH . '/functions/artist_custom_post.php';
require_once ARTIST_PATH_SERVER_PATH . '/functions/artist_metaboxes.php';
require_once ARTIST_PATH_SERVER_PATH . '/functions/tinymce_shortcodebutton.php'; 
require_once ARTIST_PATH_SERVER_PATH . '/functions/artist_enqueue.php'; 
require_once ARTIST_PATH_SERVER_PATH . '/functions/artist_widget.php'; 
require_once get_template_directory() .'/radium-one-click-demo-install-master/init.php';
?>